<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://admin.eva.epitglobal.com/api_evstream/apiface?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://admin.eva.epitglobal.com/api_evstream/apiface?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for OTAH ServiceType
 */
$oTAH = new \ServiceType\OTAH($options);
/**
 * Sample call for OTA_HotelRatePlan operation/method
 */
if ($oTAH->OTA_HotelRatePlan(new \StructType\OTA_HotelRatePlanRQ()) !== false) {
    print_r($oTAH->getResult());
} else {
    print_r($oTAH->getLastError());
}
/**
 * Sample call for OTA_HotelAvailNotif operation/method
 */
if ($oTAH->OTA_HotelAvailNotif(new \StructType\OTA_HotelAvailNotifRQ()) !== false) {
    print_r($oTAH->getResult());
} else {
    print_r($oTAH->getLastError());
}
/**
 * Sample call for OTA_HotelRateAmountNotif operation/method
 */
if ($oTAH->OTA_HotelRateAmountNotif(new \StructType\OTA_HotelRateAmountNotifRQ()) !== false) {
    print_r($oTAH->getResult());
} else {
    print_r($oTAH->getLastError());
}
/**
 * Samples for OTAR ServiceType
 */
$oTAR = new \ServiceType\OTAR($options);
/**
 * Sample call for OTA_Read operation/method
 */
if ($oTAR->OTA_Read(new \StructType\OTA_ReadRQ()) !== false) {
    print_r($oTAR->getResult());
} else {
    print_r($oTAR->getLastError());
}
/**
 * Samples for OTAN ServiceType
 */
$oTAN = new \ServiceType\OTAN($options);
/**
 * Sample call for OTA_NotifReport operation/method
 */
if ($oTAN->OTA_NotifReport(new \StructType\OTA_NotifReportRQ()) !== false) {
    print_r($oTAN->getResult());
} else {
    print_r($oTAN->getLastError());
}
