<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher StructType
 * Meta information extracted from the WSDL
 * - documentation: The effective date, expiry date and series code of the voucher. | Details of a paper or electronic document indicating prepayment.
 * @subpackage Structs
 */
class Voucher extends AbstractStructBase
{
    /**
     * The BillingAccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingAccountName
     */
    public $BillingAccountName;
    /**
     * The BillingAccountAddress
     * Meta information extracted from the WSDL
     * - documentation: The address of the Billing Account for which the voucher has been issued.
     * - minOccurs: 0
     * @var mixed
     */
    public $BillingAccountAddress;
    /**
     * The BillingNumber
     * Meta information extracted from the WSDL
     * - documentation: Reference of the billing account which handles the payment transaction.
     * - use: optional
     * @var string
     */
    public $BillingNumber;
    /**
     * The SupplierIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the electronic voucher, created by the supplier.
     * - use: optional
     * @var string
     */
    public $SupplierIdentifier;
    /**
     * The Identifier
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the electronic voucher.
     * - use: optional
     * @var string
     */
    public $Identifier;
    /**
     * The ValueType
     * Meta information extracted from the WSDL
     * - documentation: Defines the type of voucher (e.g., full credit or partial credit).
     * - use: optional
     * @var string
     */
    public $ValueType;
    /**
     * The ElectronicIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the voucher is electronic. An E-voucher is a value document issued by the Travel Agent for the customer. The e-voucher can be used as a proof of reservation, but more normally, as a full-payment or partial
     * payment.
     * - use: optional
     * @var bool
     */
    public $ElectronicIndicator;
    /**
     * The GroupDaysApplyInd
     * Meta information extracted from the WSDL
     * - documentation: When true, specifies the Group Days Apply Value can be used for this Voucher Billing Account. This indicator is used to allow the usage of a car rental days voucher when part of an inclusive tour.
     * - use: optional
     * @var bool
     */
    public $GroupDaysApplyInd;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setBillingAccountName()
     * @uses Voucher::setBillingAccountAddress()
     * @uses Voucher::setBillingNumber()
     * @uses Voucher::setSupplierIdentifier()
     * @uses Voucher::setIdentifier()
     * @uses Voucher::setValueType()
     * @uses Voucher::setElectronicIndicator()
     * @uses Voucher::setGroupDaysApplyInd()
     * @param \StructType\BillingAccountName $billingAccountName
     * @param mixed $billingAccountAddress
     * @param string $billingNumber
     * @param string $supplierIdentifier
     * @param string $identifier
     * @param string $valueType
     * @param bool $electronicIndicator
     * @param bool $groupDaysApplyInd
     */
    public function __construct(\StructType\BillingAccountName $billingAccountName = null, $billingAccountAddress = null, $billingNumber = null, $supplierIdentifier = null, $identifier = null, $valueType = null, $electronicIndicator = null, $groupDaysApplyInd = null)
    {
        $this
            ->setBillingAccountName($billingAccountName)
            ->setBillingAccountAddress($billingAccountAddress)
            ->setBillingNumber($billingNumber)
            ->setSupplierIdentifier($supplierIdentifier)
            ->setIdentifier($identifier)
            ->setValueType($valueType)
            ->setElectronicIndicator($electronicIndicator)
            ->setGroupDaysApplyInd($groupDaysApplyInd);
    }
    /**
     * Get BillingAccountName value
     * @return \StructType\BillingAccountName|null
     */
    public function getBillingAccountName()
    {
        return $this->BillingAccountName;
    }
    /**
     * Set BillingAccountName value
     * @param \StructType\BillingAccountName $billingAccountName
     * @return \StructType\Voucher
     */
    public function setBillingAccountName(\StructType\BillingAccountName $billingAccountName = null)
    {
        $this->BillingAccountName = $billingAccountName;
        return $this;
    }
    /**
     * Get BillingAccountAddress value
     * @return mixed|null
     */
    public function getBillingAccountAddress()
    {
        return $this->BillingAccountAddress;
    }
    /**
     * Set BillingAccountAddress value
     * @param mixed $billingAccountAddress
     * @return \StructType\Voucher
     */
    public function setBillingAccountAddress($billingAccountAddress = null)
    {
        $this->BillingAccountAddress = $billingAccountAddress;
        return $this;
    }
    /**
     * Get BillingNumber value
     * @return string|null
     */
    public function getBillingNumber()
    {
        return $this->BillingNumber;
    }
    /**
     * Set BillingNumber value
     * @param string $billingNumber
     * @return \StructType\Voucher
     */
    public function setBillingNumber($billingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingNumber) && !is_string($billingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingNumber, true), gettype($billingNumber)), __LINE__);
        }
        $this->BillingNumber = $billingNumber;
        return $this;
    }
    /**
     * Get SupplierIdentifier value
     * @return string|null
     */
    public function getSupplierIdentifier()
    {
        return $this->SupplierIdentifier;
    }
    /**
     * Set SupplierIdentifier value
     * @param string $supplierIdentifier
     * @return \StructType\Voucher
     */
    public function setSupplierIdentifier($supplierIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplierIdentifier) && !is_string($supplierIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierIdentifier, true), gettype($supplierIdentifier)), __LINE__);
        }
        $this->SupplierIdentifier = $supplierIdentifier;
        return $this;
    }
    /**
     * Get Identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param string $identifier
     * @return \StructType\Voucher
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @param string $valueType
     * @return \StructType\Voucher
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: string
        if (!is_null($valueType) && !is_string($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueType, true), gettype($valueType)), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
    /**
     * Get ElectronicIndicator value
     * @return bool|null
     */
    public function getElectronicIndicator()
    {
        return $this->ElectronicIndicator;
    }
    /**
     * Set ElectronicIndicator value
     * @param bool $electronicIndicator
     * @return \StructType\Voucher
     */
    public function setElectronicIndicator($electronicIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($electronicIndicator) && !is_bool($electronicIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($electronicIndicator, true), gettype($electronicIndicator)), __LINE__);
        }
        $this->ElectronicIndicator = $electronicIndicator;
        return $this;
    }
    /**
     * Get GroupDaysApplyInd value
     * @return bool|null
     */
    public function getGroupDaysApplyInd()
    {
        return $this->GroupDaysApplyInd;
    }
    /**
     * Set GroupDaysApplyInd value
     * @param bool $groupDaysApplyInd
     * @return \StructType\Voucher
     */
    public function setGroupDaysApplyInd($groupDaysApplyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupDaysApplyInd) && !is_bool($groupDaysApplyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupDaysApplyInd, true), gettype($groupDaysApplyInd)), __LINE__);
        }
        $this->GroupDaysApplyInd = $groupDaysApplyInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Voucher
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
