<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies any preferences in terms of the company operating the train service. | Specify vendors to include and exclude from the response. | Identifies the preferred airline carrier(s) by name. | Indicates the preferred Vendor
 * Company for the vehicle rental. If a company name is supplied, the rates will be supplied for the specific Vendor Company. The company name is unique amongst the vendors.
 * @subpackage Structs
 */
class VendorPref extends CompanyNamePrefType
{
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A reference pointer used to identify an rail operator. | A reference pointer used to identify an airline vendor.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The AllianceAllowedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, flights for other airlines in an alliance with the specified carrier code may be returned.
     * - use: optional
     * @var bool
     */
    public $AllianceAllowedInd;
    /**
     * The LoyaltyAllowedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, flights for other airlines in a loyalty program with the specified carrier code may be returned.
     * - use: optional
     * @var bool
     */
    public $LoyaltyAllowedInd;
    /**
     * The CorpDiscountNmbr
     * Meta information extracted from the WSDL
     * - documentation: This is the vendor specific code used to identify a special rate associated with a specific organization. Used when multiple vendors have been requested and there is a different code for each.
     * - use: optional
     * @var string
     */
    public $CorpDiscountNmbr;
    /**
     * The CompanyShortName
     * Meta information extracted from the WSDL
     * - documentation: Used to provide the company common name.
     * - use: optional
     * @var string
     */
    public $CompanyShortName;
    /**
     * The Division
     * Meta information extracted from the WSDL
     * - documentation: The division name or ID with which the contact is associated.
     * - use: optional
     * @var string
     */
    public $Division;
    /**
     * The Department
     * Meta information extracted from the WSDL
     * - documentation: The department name or ID with which the contact is associated.
     * - use: optional
     * @var string
     */
    public $Department;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - documentation: Preferred | Used to indicate a level of preference for an associated item.
     * - use: optional
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for VendorPref
     * @uses VendorPref::setRPH()
     * @uses VendorPref::setAllianceAllowedInd()
     * @uses VendorPref::setLoyaltyAllowedInd()
     * @uses VendorPref::setCorpDiscountNmbr()
     * @uses VendorPref::setCompanyShortName()
     * @uses VendorPref::setDivision()
     * @uses VendorPref::setDepartment()
     * @uses VendorPref::setPreferLevel()
     * @param string $rPH
     * @param bool $allianceAllowedInd
     * @param bool $loyaltyAllowedInd
     * @param string $corpDiscountNmbr
     * @param string $companyShortName
     * @param string $division
     * @param string $department
     * @param string $preferLevel
     */
    public function __construct($rPH = null, $allianceAllowedInd = null, $loyaltyAllowedInd = null, $corpDiscountNmbr = null, $companyShortName = null, $division = null, $department = null, $preferLevel = null)
    {
        $this
            ->setRPH($rPH)
            ->setAllianceAllowedInd($allianceAllowedInd)
            ->setLoyaltyAllowedInd($loyaltyAllowedInd)
            ->setCorpDiscountNmbr($corpDiscountNmbr)
            ->setCompanyShortName($companyShortName)
            ->setDivision($division)
            ->setDepartment($department)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\VendorPref
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get AllianceAllowedInd value
     * @return bool|null
     */
    public function getAllianceAllowedInd()
    {
        return $this->AllianceAllowedInd;
    }
    /**
     * Set AllianceAllowedInd value
     * @param bool $allianceAllowedInd
     * @return \StructType\VendorPref
     */
    public function setAllianceAllowedInd($allianceAllowedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allianceAllowedInd) && !is_bool($allianceAllowedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allianceAllowedInd, true), gettype($allianceAllowedInd)), __LINE__);
        }
        $this->AllianceAllowedInd = $allianceAllowedInd;
        return $this;
    }
    /**
     * Get LoyaltyAllowedInd value
     * @return bool|null
     */
    public function getLoyaltyAllowedInd()
    {
        return $this->LoyaltyAllowedInd;
    }
    /**
     * Set LoyaltyAllowedInd value
     * @param bool $loyaltyAllowedInd
     * @return \StructType\VendorPref
     */
    public function setLoyaltyAllowedInd($loyaltyAllowedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($loyaltyAllowedInd) && !is_bool($loyaltyAllowedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loyaltyAllowedInd, true), gettype($loyaltyAllowedInd)), __LINE__);
        }
        $this->LoyaltyAllowedInd = $loyaltyAllowedInd;
        return $this;
    }
    /**
     * Get CorpDiscountNmbr value
     * @return string|null
     */
    public function getCorpDiscountNmbr()
    {
        return $this->CorpDiscountNmbr;
    }
    /**
     * Set CorpDiscountNmbr value
     * @param string $corpDiscountNmbr
     * @return \StructType\VendorPref
     */
    public function setCorpDiscountNmbr($corpDiscountNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($corpDiscountNmbr) && !is_string($corpDiscountNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corpDiscountNmbr, true), gettype($corpDiscountNmbr)), __LINE__);
        }
        $this->CorpDiscountNmbr = $corpDiscountNmbr;
        return $this;
    }
    /**
     * Get CompanyShortName value
     * @return string|null
     */
    public function getCompanyShortName()
    {
        return $this->CompanyShortName;
    }
    /**
     * Set CompanyShortName value
     * @param string $companyShortName
     * @return \StructType\VendorPref
     */
    public function setCompanyShortName($companyShortName = null)
    {
        // validation for constraint: string
        if (!is_null($companyShortName) && !is_string($companyShortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyShortName, true), gettype($companyShortName)), __LINE__);
        }
        $this->CompanyShortName = $companyShortName;
        return $this;
    }
    /**
     * Get Division value
     * @return string|null
     */
    public function getDivision()
    {
        return $this->Division;
    }
    /**
     * Set Division value
     * @param string $division
     * @return \StructType\VendorPref
     */
    public function setDivision($division = null)
    {
        // validation for constraint: string
        if (!is_null($division) && !is_string($division)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($division, true), gettype($division)), __LINE__);
        }
        $this->Division = $division;
        return $this;
    }
    /**
     * Get Department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @param string $department
     * @return \StructType\VendorPref
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        $this->Department = $department;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\VendorPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
