<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleType StructType
 * Meta information extracted from the WSDL
 * - documentation: The effective date range for the vehicle information. | The volume (i.e., unit of measure and quantity) of the boot/trunk. | Code used to identify the vehicle. May be used in place of VehicleCoreType. Typically a SIPP code would be
 * passed here. Identifies the source authority for the code (e.g., SIPP). | The VehicleType complex type identifie sthe data that fully describes a vehicle. This includes the core information along with supplemental information such as make and model,
 * and a link to a picture.
 * @subpackage Structs
 */
class VehicleType extends VehicleCoreType
{
    /**
     * The VehMakeModel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehMakeModel
     */
    public $VehMakeModel;
    /**
     * The PictureURL
     * Meta information extracted from the WSDL
     * - documentation: URL that identifies the location of a picture to describe this vehicle.
     * - minOccurs: 0
     * @var string
     */
    public $PictureURL;
    /**
     * The VehIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehIdentity
     */
    public $VehIdentity;
    /**
     * The PassengerQuantity
     * Meta information extracted from the WSDL
     * - documentation: Number of passengers that can be accommodated by this vehicle. This may be an exact number or may be a range, i.e., 4-5, 5-6.
     * - use: optional
     * @var string
     */
    public $PassengerQuantity;
    /**
     * The BaggageQuantity
     * Meta information extracted from the WSDL
     * - documentation: Number of bags/suitcases that can be accommodated by this vehicle.
     * - use: optional
     * @var int
     */
    public $BaggageQuantity;
    /**
     * The VendorCarType
     * Meta information extracted from the WSDL
     * - documentation: An internal car type assigned by the vendor. This is not the SIPP code.
     * - use: optional
     * @var string
     */
    public $VendorCarType;
    /**
     * The OdometerUnitOfMeasure
     * Meta information extracted from the WSDL
     * - documentation: Provides the units in which distance is measured, when applied to a vehicle (i.e., miles or kilometers)
     * - use: optional
     * @var string
     */
    public $OdometerUnitOfMeasure;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A description of the vehicle.
     * @var string
     */
    public $Description;
    /**
     * Constructor method for VehicleType
     * @uses VehicleType::setVehMakeModel()
     * @uses VehicleType::setPictureURL()
     * @uses VehicleType::setVehIdentity()
     * @uses VehicleType::setPassengerQuantity()
     * @uses VehicleType::setBaggageQuantity()
     * @uses VehicleType::setVendorCarType()
     * @uses VehicleType::setOdometerUnitOfMeasure()
     * @uses VehicleType::setDescription()
     * @param \StructType\VehMakeModel $vehMakeModel
     * @param string $pictureURL
     * @param \StructType\VehIdentity $vehIdentity
     * @param string $passengerQuantity
     * @param int $baggageQuantity
     * @param string $vendorCarType
     * @param string $odometerUnitOfMeasure
     * @param string $description
     */
    public function __construct(\StructType\VehMakeModel $vehMakeModel = null, $pictureURL = null, \StructType\VehIdentity $vehIdentity = null, $passengerQuantity = null, $baggageQuantity = null, $vendorCarType = null, $odometerUnitOfMeasure = null, $description = null)
    {
        $this
            ->setVehMakeModel($vehMakeModel)
            ->setPictureURL($pictureURL)
            ->setVehIdentity($vehIdentity)
            ->setPassengerQuantity($passengerQuantity)
            ->setBaggageQuantity($baggageQuantity)
            ->setVendorCarType($vendorCarType)
            ->setOdometerUnitOfMeasure($odometerUnitOfMeasure)
            ->setDescription($description);
    }
    /**
     * Get VehMakeModel value
     * @return \StructType\VehMakeModel|null
     */
    public function getVehMakeModel()
    {
        return $this->VehMakeModel;
    }
    /**
     * Set VehMakeModel value
     * @param \StructType\VehMakeModel $vehMakeModel
     * @return \StructType\VehicleType
     */
    public function setVehMakeModel(\StructType\VehMakeModel $vehMakeModel = null)
    {
        $this->VehMakeModel = $vehMakeModel;
        return $this;
    }
    /**
     * Get PictureURL value
     * @return string|null
     */
    public function getPictureURL()
    {
        return $this->PictureURL;
    }
    /**
     * Set PictureURL value
     * @param string $pictureURL
     * @return \StructType\VehicleType
     */
    public function setPictureURL($pictureURL = null)
    {
        // validation for constraint: string
        if (!is_null($pictureURL) && !is_string($pictureURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureURL, true), gettype($pictureURL)), __LINE__);
        }
        $this->PictureURL = $pictureURL;
        return $this;
    }
    /**
     * Get VehIdentity value
     * @return \StructType\VehIdentity|null
     */
    public function getVehIdentity()
    {
        return $this->VehIdentity;
    }
    /**
     * Set VehIdentity value
     * @param \StructType\VehIdentity $vehIdentity
     * @return \StructType\VehicleType
     */
    public function setVehIdentity(\StructType\VehIdentity $vehIdentity = null)
    {
        $this->VehIdentity = $vehIdentity;
        return $this;
    }
    /**
     * Get PassengerQuantity value
     * @return string|null
     */
    public function getPassengerQuantity()
    {
        return $this->PassengerQuantity;
    }
    /**
     * Set PassengerQuantity value
     * @param string $passengerQuantity
     * @return \StructType\VehicleType
     */
    public function setPassengerQuantity($passengerQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($passengerQuantity) && !is_string($passengerQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerQuantity, true), gettype($passengerQuantity)), __LINE__);
        }
        $this->PassengerQuantity = $passengerQuantity;
        return $this;
    }
    /**
     * Get BaggageQuantity value
     * @return int|null
     */
    public function getBaggageQuantity()
    {
        return $this->BaggageQuantity;
    }
    /**
     * Set BaggageQuantity value
     * @param int $baggageQuantity
     * @return \StructType\VehicleType
     */
    public function setBaggageQuantity($baggageQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($baggageQuantity) && !(is_int($baggageQuantity) || ctype_digit($baggageQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baggageQuantity, true), gettype($baggageQuantity)), __LINE__);
        }
        $this->BaggageQuantity = $baggageQuantity;
        return $this;
    }
    /**
     * Get VendorCarType value
     * @return string|null
     */
    public function getVendorCarType()
    {
        return $this->VendorCarType;
    }
    /**
     * Set VendorCarType value
     * @param string $vendorCarType
     * @return \StructType\VehicleType
     */
    public function setVendorCarType($vendorCarType = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCarType) && !is_string($vendorCarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCarType, true), gettype($vendorCarType)), __LINE__);
        }
        $this->VendorCarType = $vendorCarType;
        return $this;
    }
    /**
     * Get OdometerUnitOfMeasure value
     * @return string|null
     */
    public function getOdometerUnitOfMeasure()
    {
        return $this->OdometerUnitOfMeasure;
    }
    /**
     * Set OdometerUnitOfMeasure value
     * @uses \EnumType\DistanceUnitNameType::valueIsValid()
     * @uses \EnumType\DistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odometerUnitOfMeasure
     * @return \StructType\VehicleType
     */
    public function setOdometerUnitOfMeasure($odometerUnitOfMeasure = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnitNameType::valueIsValid($odometerUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistanceUnitNameType', is_array($odometerUnitOfMeasure) ? implode(', ', $odometerUnitOfMeasure) : var_export($odometerUnitOfMeasure, true), implode(', ', \EnumType\DistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->OdometerUnitOfMeasure = $odometerUnitOfMeasure;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\VehicleType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
