<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleSegmentCoreType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleSegmentCoreType complex type identifies the core, or common, data that descibes the information assocated with a vehicle segment. Such information is typically provided in a reservation.
 * @subpackage Structs
 */
class VehicleSegmentCoreType extends AbstractStructBase
{
    /**
     * The ConfID
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * @var \StructType\ConfID[]
     */
    public $ConfID;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - documentation: Identifies the vendor associated with this information.
     * - minOccurs: 0
     * @var mixed
     */
    public $Vendor;
    /**
     * The VehRentalCore
     * Meta information extracted from the WSDL
     * - documentation: Information that is common, or core, to all requests and responses associated with the reservation of a vehicle.
     * - minOccurs: 0
     * @var mixed
     */
    public $VehRentalCore;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - documentation: Information on one specific vehicle along with detailed information on the charges associated with this vehicle.
     * - minOccurs: 0
     * @var mixed
     */
    public $Vehicle;
    /**
     * The RentalRate
     * Meta information extracted from the WSDL
     * - documentation: Information on the rates associated with this vehicle. Rate information can include the distance and the base rental cost, along with information on the various factors that may infuence this rate.
     * - minOccurs: 0
     * @var mixed
     */
    public $RentalRate;
    /**
     * The PricedEquips
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricedEquips
     */
    public $PricedEquips;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fees
     */
    public $Fees;
    /**
     * The TotalCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalCharge
     */
    public $TotalCharge;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The IndexNumber
     * Meta information extracted from the WSDL
     * - documentation: A unique number (e.g., segment number or index number) used to further identify a booked item within a list of booked items in a multi-segment PNR. Typically not used in messages to car suppliers.
     * - use: optional
     * @var int
     */
    public $IndexNumber;
    /**
     * Constructor method for VehicleSegmentCoreType
     * @uses VehicleSegmentCoreType::setConfID()
     * @uses VehicleSegmentCoreType::setVendor()
     * @uses VehicleSegmentCoreType::setVehRentalCore()
     * @uses VehicleSegmentCoreType::setVehicle()
     * @uses VehicleSegmentCoreType::setRentalRate()
     * @uses VehicleSegmentCoreType::setPricedEquips()
     * @uses VehicleSegmentCoreType::setFees()
     * @uses VehicleSegmentCoreType::setTotalCharge()
     * @uses VehicleSegmentCoreType::setTPA_Extensions()
     * @uses VehicleSegmentCoreType::setIndexNumber()
     * @param \StructType\ConfID[] $confID
     * @param mixed $vendor
     * @param mixed $vehRentalCore
     * @param mixed $vehicle
     * @param mixed $rentalRate
     * @param \StructType\PricedEquips $pricedEquips
     * @param \StructType\Fees $fees
     * @param \StructType\TotalCharge $totalCharge
     * @param mixed $tPA_Extensions
     * @param int $indexNumber
     */
    public function __construct(array $confID = array(), $vendor = null, $vehRentalCore = null, $vehicle = null, $rentalRate = null, \StructType\PricedEquips $pricedEquips = null, \StructType\Fees $fees = null, \StructType\TotalCharge $totalCharge = null, $tPA_Extensions = null, $indexNumber = null)
    {
        $this
            ->setConfID($confID)
            ->setVendor($vendor)
            ->setVehRentalCore($vehRentalCore)
            ->setVehicle($vehicle)
            ->setRentalRate($rentalRate)
            ->setPricedEquips($pricedEquips)
            ->setFees($fees)
            ->setTotalCharge($totalCharge)
            ->setTPA_Extensions($tPA_Extensions)
            ->setIndexNumber($indexNumber);
    }
    /**
     * Get ConfID value
     * @return \StructType\ConfID[]|null
     */
    public function getConfID()
    {
        return $this->ConfID;
    }
    /**
     * This method is responsible for validating the values passed to the setConfID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConfIDForArrayConstraintsFromSetConfID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleSegmentCoreTypeConfIDItem) {
            // validation for constraint: itemType
            if (!$vehicleSegmentCoreTypeConfIDItem instanceof \StructType\ConfID) {
                $invalidValues[] = is_object($vehicleSegmentCoreTypeConfIDItem) ? get_class($vehicleSegmentCoreTypeConfIDItem) : sprintf('%s(%s)', gettype($vehicleSegmentCoreTypeConfIDItem), var_export($vehicleSegmentCoreTypeConfIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConfID property can only contain items of type \StructType\ConfID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConfID value
     * @throws \InvalidArgumentException
     * @param \StructType\ConfID[] $confID
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setConfID(array $confID = array())
    {
        // validation for constraint: array
        if ('' !== ($confIDArrayErrorMessage = self::validateConfIDForArrayConstraintsFromSetConfID($confID))) {
            throw new \InvalidArgumentException($confIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($confID) && count($confID) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($confID)), __LINE__);
        }
        $this->ConfID = $confID;
        return $this;
    }
    /**
     * Add item to ConfID value
     * @throws \InvalidArgumentException
     * @param \StructType\ConfID $item
     * @return \StructType\VehicleSegmentCoreType
     */
    public function addToConfID(\StructType\ConfID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConfID) {
            throw new \InvalidArgumentException(sprintf('The ConfID property can only contain items of type \StructType\ConfID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->ConfID) && count($this->ConfID) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->ConfID)), __LINE__);
        }
        $this->ConfID[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return mixed|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param mixed $vendor
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setVendor($vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get VehRentalCore value
     * @return mixed|null
     */
    public function getVehRentalCore()
    {
        return $this->VehRentalCore;
    }
    /**
     * Set VehRentalCore value
     * @param mixed $vehRentalCore
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setVehRentalCore($vehRentalCore = null)
    {
        $this->VehRentalCore = $vehRentalCore;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return mixed|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param mixed $vehicle
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setVehicle($vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get RentalRate value
     * @return mixed|null
     */
    public function getRentalRate()
    {
        return $this->RentalRate;
    }
    /**
     * Set RentalRate value
     * @param mixed $rentalRate
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setRentalRate($rentalRate = null)
    {
        $this->RentalRate = $rentalRate;
        return $this;
    }
    /**
     * Get PricedEquips value
     * @return \StructType\PricedEquips|null
     */
    public function getPricedEquips()
    {
        return $this->PricedEquips;
    }
    /**
     * Set PricedEquips value
     * @param \StructType\PricedEquips $pricedEquips
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setPricedEquips(\StructType\PricedEquips $pricedEquips = null)
    {
        $this->PricedEquips = $pricedEquips;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\Fees $fees
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setFees(\StructType\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \StructType\TotalCharge|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * Set TotalCharge value
     * @param \StructType\TotalCharge $totalCharge
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setTotalCharge(\StructType\TotalCharge $totalCharge = null)
    {
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get IndexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \StructType\VehicleSegmentCoreType
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !(is_int($indexNumber) || ctype_digit($indexNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexNumber, true), gettype($indexNumber)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleSegmentCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
