<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleRetrieveResRQAdditionalInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleRetrieveInfoRQType complex type defines the supplemental data by which an existing reservation can be identified for retrieval
 * @subpackage Structs
 */
class VehicleRetrieveResRQAdditionalInfoType extends AbstractStructBase
{
    /**
     * The PickUpLocation
     * Meta information extracted from the WSDL
     * - documentation: A code to identify the pick up location, along with an optional code context.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $PickUpLocation;
    /**
     * The ReturnLocation
     * Meta information extracted from the WSDL
     * - documentation: A code to identify the return location, along with an optional code context.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $ReturnLocation;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $Telephone;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - documentation: The vendor with whom the reservation has been made.
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $Vendor;
    /**
     * The VehPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates any preferences for the vehicle, such as type, class, transmission, air conditioning.
     * - minOccurs: 0
     * @var \StructType\VehiclePrefType
     */
    public $VehPref;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: An email address associated with the reservation to be retrieved.
     * - minOccurs: 0
     * @var \StructType\EmailType
     */
    public $Email;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Free text description regarding the rental to be retrieved.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $Remark;
    /**
     * The SearchDateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\SearchDateRange[]
     */
    public $SearchDateRange;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The PickUpDateTime
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PickUpDateTime;
    /**
     * Constructor method for VehicleRetrieveResRQAdditionalInfoType
     * @uses VehicleRetrieveResRQAdditionalInfoType::setPickUpLocation()
     * @uses VehicleRetrieveResRQAdditionalInfoType::setReturnLocation()
     * @uses VehicleRetrieveResRQAdditionalInfoType::setTelephone()
     * @uses VehicleRetrieveResRQAdditionalInfoType::setVendor()
     * @uses VehicleRetrieveResRQAdditionalInfoType::setVehPref()
     * @uses VehicleRetrieveResRQAdditionalInfoType::setEmail()
     * @uses VehicleRetrieveResRQAdditionalInfoType::setRemark()
     * @uses VehicleRetrieveResRQAdditionalInfoType::setSearchDateRange()
     * @uses VehicleRetrieveResRQAdditionalInfoType::setTPA_Extensions()
     * @uses VehicleRetrieveResRQAdditionalInfoType::setPickUpDateTime()
     * @param \StructType\LocationType $pickUpLocation
     * @param \StructType\LocationType $returnLocation
     * @param \StructType\Telephone $telephone
     * @param \StructType\CompanyNameType $vendor
     * @param \StructType\VehiclePrefType $vehPref
     * @param \StructType\EmailType $email
     * @param \StructType\ParagraphType[] $remark
     * @param \StructType\SearchDateRange[] $searchDateRange
     * @param mixed $tPA_Extensions
     * @param string $pickUpDateTime
     */
    public function __construct(\StructType\LocationType $pickUpLocation = null, \StructType\LocationType $returnLocation = null, \StructType\Telephone $telephone = null, \StructType\CompanyNameType $vendor = null, \StructType\VehiclePrefType $vehPref = null, \StructType\EmailType $email = null, array $remark = array(), array $searchDateRange = array(), $tPA_Extensions = null, $pickUpDateTime = null)
    {
        $this
            ->setPickUpLocation($pickUpLocation)
            ->setReturnLocation($returnLocation)
            ->setTelephone($telephone)
            ->setVendor($vendor)
            ->setVehPref($vehPref)
            ->setEmail($email)
            ->setRemark($remark)
            ->setSearchDateRange($searchDateRange)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPickUpDateTime($pickUpDateTime);
    }
    /**
     * Get PickUpLocation value
     * @return \StructType\LocationType|null
     */
    public function getPickUpLocation()
    {
        return $this->PickUpLocation;
    }
    /**
     * Set PickUpLocation value
     * @param \StructType\LocationType $pickUpLocation
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setPickUpLocation(\StructType\LocationType $pickUpLocation = null)
    {
        $this->PickUpLocation = $pickUpLocation;
        return $this;
    }
    /**
     * Get ReturnLocation value
     * @return \StructType\LocationType|null
     */
    public function getReturnLocation()
    {
        return $this->ReturnLocation;
    }
    /**
     * Set ReturnLocation value
     * @param \StructType\LocationType $returnLocation
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setReturnLocation(\StructType\LocationType $returnLocation = null)
    {
        $this->ReturnLocation = $returnLocation;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\Telephone $telephone
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setTelephone(\StructType\Telephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \StructType\CompanyNameType|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \StructType\CompanyNameType $vendor
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setVendor(\StructType\CompanyNameType $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get VehPref value
     * @return \StructType\VehiclePrefType|null
     */
    public function getVehPref()
    {
        return $this->VehPref;
    }
    /**
     * Set VehPref value
     * @param \StructType\VehiclePrefType $vehPref
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setVehPref(\StructType\VehiclePrefType $vehPref = null)
    {
        $this->VehPref = $vehPref;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\EmailType|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \StructType\EmailType $email
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setEmail(\StructType\EmailType $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Remark value
     * @return \StructType\ParagraphType[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleRetrieveResRQAdditionalInfoTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$vehicleRetrieveResRQAdditionalInfoTypeRemarkItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($vehicleRetrieveResRQAdditionalInfoTypeRemarkItem) ? get_class($vehicleRetrieveResRQAdditionalInfoTypeRemarkItem) : sprintf('%s(%s)', gettype($vehicleRetrieveResRQAdditionalInfoTypeRemarkItem), var_export($vehicleRetrieveResRQAdditionalInfoTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $remark
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($remark) && count($remark) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function addToRemark(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Remark) && count($this->Remark) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Remark)), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get SearchDateRange value
     * @return \StructType\SearchDateRange[]|null
     */
    public function getSearchDateRange()
    {
        return $this->SearchDateRange;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchDateRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchDateRange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchDateRangeForArrayConstraintsFromSetSearchDateRange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleRetrieveResRQAdditionalInfoTypeSearchDateRangeItem) {
            // validation for constraint: itemType
            if (!$vehicleRetrieveResRQAdditionalInfoTypeSearchDateRangeItem instanceof \StructType\SearchDateRange) {
                $invalidValues[] = is_object($vehicleRetrieveResRQAdditionalInfoTypeSearchDateRangeItem) ? get_class($vehicleRetrieveResRQAdditionalInfoTypeSearchDateRangeItem) : sprintf('%s(%s)', gettype($vehicleRetrieveResRQAdditionalInfoTypeSearchDateRangeItem), var_export($vehicleRetrieveResRQAdditionalInfoTypeSearchDateRangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SearchDateRange property can only contain items of type \StructType\SearchDateRange, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SearchDateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchDateRange[] $searchDateRange
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setSearchDateRange(array $searchDateRange = array())
    {
        // validation for constraint: array
        if ('' !== ($searchDateRangeArrayErrorMessage = self::validateSearchDateRangeForArrayConstraintsFromSetSearchDateRange($searchDateRange))) {
            throw new \InvalidArgumentException($searchDateRangeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($searchDateRange) && count($searchDateRange) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($searchDateRange)), __LINE__);
        }
        $this->SearchDateRange = $searchDateRange;
        return $this;
    }
    /**
     * Add item to SearchDateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchDateRange $item
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function addToSearchDateRange(\StructType\SearchDateRange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchDateRange) {
            throw new \InvalidArgumentException(sprintf('The SearchDateRange property can only contain items of type \StructType\SearchDateRange, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->SearchDateRange) && count($this->SearchDateRange) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->SearchDateRange)), __LINE__);
        }
        $this->SearchDateRange[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PickUpDateTime value
     * @return string|null
     */
    public function getPickUpDateTime()
    {
        return $this->PickUpDateTime;
    }
    /**
     * Set PickUpDateTime value
     * @param string $pickUpDateTime
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public function setPickUpDateTime($pickUpDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpDateTime) && !is_string($pickUpDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpDateTime, true), gettype($pickUpDateTime)), __LINE__);
        }
        $this->PickUpDateTime = $pickUpDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleRetrieveResRQAdditionalInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
