<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleReservationRQAdditionalInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the supplemental information that may be included when requesting the reservation of a vehicle.
 * @subpackage Structs
 */
class VehicleReservationRQAdditionalInfoType extends AbstractStructBase
{
    /**
     * The SpecialReqPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates the preference associated with special needs or requirements of the customer, described using free text
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SpecialReqPref;
    /**
     * The CoveragePrefs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CoveragePrefs
     */
    public $CoveragePrefs;
    /**
     * The OffLocService
     * Meta information extracted from the WSDL
     * - documentation: Information on requested off-airport location services, for example, vehicle delivery, customer pickup.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var mixed[]
     */
    public $OffLocService;
    /**
     * The ArrivalDetails
     * Meta information extracted from the WSDL
     * - documentation: Details of the arrival transportation, if applicable
     * - minOccurs: 0
     * @var mixed
     */
    public $ArrivalDetails;
    /**
     * The RentalPaymentPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\RentalPaymentPref[]
     */
    public $RentalPaymentPref;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $Reference;
    /**
     * The TourInfo
     * Meta information extracted from the WSDL
     * - documentation: Details of a tour with which this reservation information is associated. Availability and rate information may vary if associated with a tour.
     * - minOccurs: 0
     * @var mixed
     */
    public $TourInfo;
    /**
     * The WrittenConfInst
     * Meta information extracted from the WSDL
     * - documentation: Used to provide instructions regarding cusotmer preferences for receiving confirmation information.
     * - minOccurs: 0
     * @var mixed
     */
    public $WrittenConfInst;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Free text description regarding the rental (e.g. vehicle is being rented because of an accident).
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Remark;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The LuggageQty
     * Meta information extracted from the WSDL
     * - documentation: The quantity of suitcases that can typically fit in the trunk of the car.
     * - use: optional
     * @var int
     */
    public $LuggageQty;
    /**
     * The PassengerQty
     * Meta information extracted from the WSDL
     * - documentation: The quantity of (seat-belted) passengers that can fit in the vehicle.
     * - use: optional
     * @var int
     */
    public $PassengerQty;
    /**
     * The GasPrePay
     * Meta information extracted from the WSDL
     * - documentation: false | The GasPrePay attribute defines a set of valid values for the choice of prepaying for gas at the time of the pick up of the rental vehicle. This information is useful in that it allows a customer's preference to be made known
     * to the vendor. It also allows the vendor to provide more detailed and accurate pricing up front.
     * - use: optional
     * @var bool
     */
    public $GasPrePay;
    /**
     * Constructor method for VehicleReservationRQAdditionalInfoType
     * @uses VehicleReservationRQAdditionalInfoType::setSpecialReqPref()
     * @uses VehicleReservationRQAdditionalInfoType::setCoveragePrefs()
     * @uses VehicleReservationRQAdditionalInfoType::setOffLocService()
     * @uses VehicleReservationRQAdditionalInfoType::setArrivalDetails()
     * @uses VehicleReservationRQAdditionalInfoType::setRentalPaymentPref()
     * @uses VehicleReservationRQAdditionalInfoType::setReference()
     * @uses VehicleReservationRQAdditionalInfoType::setTourInfo()
     * @uses VehicleReservationRQAdditionalInfoType::setWrittenConfInst()
     * @uses VehicleReservationRQAdditionalInfoType::setRemark()
     * @uses VehicleReservationRQAdditionalInfoType::setTPA_Extensions()
     * @uses VehicleReservationRQAdditionalInfoType::setLuggageQty()
     * @uses VehicleReservationRQAdditionalInfoType::setPassengerQty()
     * @uses VehicleReservationRQAdditionalInfoType::setGasPrePay()
     * @param mixed[] $specialReqPref
     * @param \StructType\CoveragePrefs $coveragePrefs
     * @param mixed[] $offLocService
     * @param mixed $arrivalDetails
     * @param \StructType\RentalPaymentPref[] $rentalPaymentPref
     * @param \StructType\Reference $reference
     * @param mixed $tourInfo
     * @param mixed $writtenConfInst
     * @param mixed[] $remark
     * @param mixed $tPA_Extensions
     * @param int $luggageQty
     * @param int $passengerQty
     * @param bool $gasPrePay
     */
    public function __construct(array $specialReqPref = array(), \StructType\CoveragePrefs $coveragePrefs = null, array $offLocService = array(), $arrivalDetails = null, array $rentalPaymentPref = array(), \StructType\Reference $reference = null, $tourInfo = null, $writtenConfInst = null, array $remark = array(), $tPA_Extensions = null, $luggageQty = null, $passengerQty = null, $gasPrePay = null)
    {
        $this
            ->setSpecialReqPref($specialReqPref)
            ->setCoveragePrefs($coveragePrefs)
            ->setOffLocService($offLocService)
            ->setArrivalDetails($arrivalDetails)
            ->setRentalPaymentPref($rentalPaymentPref)
            ->setReference($reference)
            ->setTourInfo($tourInfo)
            ->setWrittenConfInst($writtenConfInst)
            ->setRemark($remark)
            ->setTPA_Extensions($tPA_Extensions)
            ->setLuggageQty($luggageQty)
            ->setPassengerQty($passengerQty)
            ->setGasPrePay($gasPrePay);
    }
    /**
     * Get SpecialReqPref value
     * @return mixed[]|null
     */
    public function getSpecialReqPref()
    {
        return $this->SpecialReqPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialReqPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialReqPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem) ? get_class($vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem) : sprintf('%s(%s)', gettype($vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem), var_export($vehicleReservationRQAdditionalInfoTypeSpecialReqPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialReqPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $specialReqPref
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setSpecialReqPref(array $specialReqPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specialReqPrefArrayErrorMessage = self::validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref($specialReqPref))) {
            throw new \InvalidArgumentException($specialReqPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($specialReqPref) && count($specialReqPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($specialReqPref)), __LINE__);
        }
        $this->SpecialReqPref = $specialReqPref;
        return $this;
    }
    /**
     * Add item to SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function addToSpecialReqPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->SpecialReqPref) && count($this->SpecialReqPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->SpecialReqPref)), __LINE__);
        }
        $this->SpecialReqPref[] = $item;
        return $this;
    }
    /**
     * Get CoveragePrefs value
     * @return \StructType\CoveragePrefs|null
     */
    public function getCoveragePrefs()
    {
        return $this->CoveragePrefs;
    }
    /**
     * Set CoveragePrefs value
     * @param \StructType\CoveragePrefs $coveragePrefs
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setCoveragePrefs(\StructType\CoveragePrefs $coveragePrefs = null)
    {
        $this->CoveragePrefs = $coveragePrefs;
        return $this;
    }
    /**
     * Get OffLocService value
     * @return mixed[]|null
     */
    public function getOffLocService()
    {
        return $this->OffLocService;
    }
    /**
     * This method is responsible for validating the values passed to the setOffLocService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffLocService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOffLocServiceForArrayConstraintsFromSetOffLocService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleReservationRQAdditionalInfoTypeOffLocServiceItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleReservationRQAdditionalInfoTypeOffLocServiceItem) ? get_class($vehicleReservationRQAdditionalInfoTypeOffLocServiceItem) : sprintf('%s(%s)', gettype($vehicleReservationRQAdditionalInfoTypeOffLocServiceItem), var_export($vehicleReservationRQAdditionalInfoTypeOffLocServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OffLocService property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OffLocService value
     * @throws \InvalidArgumentException
     * @param mixed[] $offLocService
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setOffLocService(array $offLocService = array())
    {
        // validation for constraint: array
        if ('' !== ($offLocServiceArrayErrorMessage = self::validateOffLocServiceForArrayConstraintsFromSetOffLocService($offLocService))) {
            throw new \InvalidArgumentException($offLocServiceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($offLocService) && count($offLocService) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($offLocService)), __LINE__);
        }
        $this->OffLocService = $offLocService;
        return $this;
    }
    /**
     * Add item to OffLocService value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function addToOffLocService($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The OffLocService property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->OffLocService) && count($this->OffLocService) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->OffLocService)), __LINE__);
        }
        $this->OffLocService[] = $item;
        return $this;
    }
    /**
     * Get ArrivalDetails value
     * @return mixed|null
     */
    public function getArrivalDetails()
    {
        return $this->ArrivalDetails;
    }
    /**
     * Set ArrivalDetails value
     * @param mixed $arrivalDetails
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setArrivalDetails($arrivalDetails = null)
    {
        $this->ArrivalDetails = $arrivalDetails;
        return $this;
    }
    /**
     * Get RentalPaymentPref value
     * @return \StructType\RentalPaymentPref[]|null
     */
    public function getRentalPaymentPref()
    {
        return $this->RentalPaymentPref;
    }
    /**
     * This method is responsible for validating the values passed to the setRentalPaymentPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRentalPaymentPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRentalPaymentPrefForArrayConstraintsFromSetRentalPaymentPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem instanceof \StructType\RentalPaymentPref) {
                $invalidValues[] = is_object($vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem) ? get_class($vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem) : sprintf('%s(%s)', gettype($vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem), var_export($vehicleReservationRQAdditionalInfoTypeRentalPaymentPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RentalPaymentPref property can only contain items of type \StructType\RentalPaymentPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RentalPaymentPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RentalPaymentPref[] $rentalPaymentPref
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setRentalPaymentPref(array $rentalPaymentPref = array())
    {
        // validation for constraint: array
        if ('' !== ($rentalPaymentPrefArrayErrorMessage = self::validateRentalPaymentPrefForArrayConstraintsFromSetRentalPaymentPref($rentalPaymentPref))) {
            throw new \InvalidArgumentException($rentalPaymentPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($rentalPaymentPref) && count($rentalPaymentPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($rentalPaymentPref)), __LINE__);
        }
        $this->RentalPaymentPref = $rentalPaymentPref;
        return $this;
    }
    /**
     * Add item to RentalPaymentPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RentalPaymentPref $item
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function addToRentalPaymentPref(\StructType\RentalPaymentPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RentalPaymentPref) {
            throw new \InvalidArgumentException(sprintf('The RentalPaymentPref property can only contain items of type \StructType\RentalPaymentPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RentalPaymentPref) && count($this->RentalPaymentPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RentalPaymentPref)), __LINE__);
        }
        $this->RentalPaymentPref[] = $item;
        return $this;
    }
    /**
     * Get Reference value
     * @return \StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \StructType\Reference $reference
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setReference(\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get TourInfo value
     * @return mixed|null
     */
    public function getTourInfo()
    {
        return $this->TourInfo;
    }
    /**
     * Set TourInfo value
     * @param mixed $tourInfo
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setTourInfo($tourInfo = null)
    {
        $this->TourInfo = $tourInfo;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return mixed|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param mixed $writtenConfInst
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setWrittenConfInst($writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get Remark value
     * @return mixed[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleReservationRQAdditionalInfoTypeRemarkItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleReservationRQAdditionalInfoTypeRemarkItem) ? get_class($vehicleReservationRQAdditionalInfoTypeRemarkItem) : sprintf('%s(%s)', gettype($vehicleReservationRQAdditionalInfoTypeRemarkItem), var_export($vehicleReservationRQAdditionalInfoTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param mixed[] $remark
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($remark) && count($remark) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function addToRemark($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Remark) && count($this->Remark) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Remark)), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get LuggageQty value
     * @return int|null
     */
    public function getLuggageQty()
    {
        return $this->LuggageQty;
    }
    /**
     * Set LuggageQty value
     * @param int $luggageQty
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setLuggageQty($luggageQty = null)
    {
        // validation for constraint: int
        if (!is_null($luggageQty) && !(is_int($luggageQty) || ctype_digit($luggageQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($luggageQty, true), gettype($luggageQty)), __LINE__);
        }
        $this->LuggageQty = $luggageQty;
        return $this;
    }
    /**
     * Get PassengerQty value
     * @return int|null
     */
    public function getPassengerQty()
    {
        return $this->PassengerQty;
    }
    /**
     * Set PassengerQty value
     * @param int $passengerQty
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setPassengerQty($passengerQty = null)
    {
        // validation for constraint: int
        if (!is_null($passengerQty) && !(is_int($passengerQty) || ctype_digit($passengerQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerQty, true), gettype($passengerQty)), __LINE__);
        }
        $this->PassengerQty = $passengerQty;
        return $this;
    }
    /**
     * Get GasPrePay value
     * @return bool|null
     */
    public function getGasPrePay()
    {
        return $this->GasPrePay;
    }
    /**
     * Set GasPrePay value
     * @param bool $gasPrePay
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public function setGasPrePay($gasPrePay = null)
    {
        // validation for constraint: boolean
        if (!is_null($gasPrePay) && !is_bool($gasPrePay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gasPrePay, true), gettype($gasPrePay)), __LINE__);
        }
        $this->GasPrePay = $gasPrePay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleReservationRQAdditionalInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
