<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleReservation StructType
 * Meta information extracted from the WSDL
 * - documentation: One line in a list of vehicle reservations. It contains the pickup and return dates, confirmation number, pickup and return locations, customer name, and vehicle information.
 * @subpackage Structs
 */
class VehicleReservation extends AbstractStructBase
{
    /**
     * The VehResSummary
     * Meta information extracted from the WSDL
     * - documentation: Summary information of a reservation, to allow a reservation to be identified from several reservations that matched the previous request criteria.
     * - maxOccurs: 99
     * @var \StructType\VehicleReservationSummaryType[]
     */
    public $VehResSummary;
    /**
     * Constructor method for VehicleReservation
     * @uses VehicleReservation::setVehResSummary()
     * @param \StructType\VehicleReservationSummaryType[] $vehResSummary
     */
    public function __construct(array $vehResSummary = array())
    {
        $this
            ->setVehResSummary($vehResSummary);
    }
    /**
     * Get VehResSummary value
     * @return \StructType\VehicleReservationSummaryType[]|null
     */
    public function getVehResSummary()
    {
        return $this->VehResSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setVehResSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehResSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehResSummaryForArrayConstraintsFromSetVehResSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleReservationVehResSummaryItem) {
            // validation for constraint: itemType
            if (!$vehicleReservationVehResSummaryItem instanceof \StructType\VehicleReservationSummaryType) {
                $invalidValues[] = is_object($vehicleReservationVehResSummaryItem) ? get_class($vehicleReservationVehResSummaryItem) : sprintf('%s(%s)', gettype($vehicleReservationVehResSummaryItem), var_export($vehicleReservationVehResSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehResSummary property can only contain items of type \StructType\VehicleReservationSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehResSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleReservationSummaryType[] $vehResSummary
     * @return \StructType\VehicleReservation
     */
    public function setVehResSummary(array $vehResSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($vehResSummaryArrayErrorMessage = self::validateVehResSummaryForArrayConstraintsFromSetVehResSummary($vehResSummary))) {
            throw new \InvalidArgumentException($vehResSummaryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vehResSummary) && count($vehResSummary) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vehResSummary)), __LINE__);
        }
        $this->VehResSummary = $vehResSummary;
        return $this;
    }
    /**
     * Add item to VehResSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleReservationSummaryType $item
     * @return \StructType\VehicleReservation
     */
    public function addToVehResSummary(\StructType\VehicleReservationSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleReservationSummaryType) {
            throw new \InvalidArgumentException(sprintf('The VehResSummary property can only contain items of type \StructType\VehicleReservationSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->VehResSummary) && count($this->VehResSummary) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->VehResSummary)), __LINE__);
        }
        $this->VehResSummary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
