<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailVendorInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleAvailVendorInfoType complex type identifies the data that describes supplemental information relevant to a vendor and made available at the time that availability and rates are checked.
 * @subpackage Structs
 */
class VehicleAvailVendorInfoType extends AbstractStructBase
{
    /**
     * The VendorMessages
     * Meta information extracted from the WSDL
     * - documentation: A collection of free-format messages associated with this vendor.
     * - minOccurs: 0
     * @var mixed
     */
    public $VendorMessages;
    /**
     * The OffLocServices
     * Meta information extracted from the WSDL
     * - documentation: Information on off-airport location services, for example, vehicle delivery, customer pickup, along with the associated price.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var mixed[]
     */
    public $OffLocServices;
    /**
     * The PaymentRules
     * Meta information extracted from the WSDL
     * - documentation: A collection of payment rules associated with this reservation. This instance of PaymentRules would be used if there were payment rules that were applicable, regardless of the vehicle.
     * - minOccurs: 0
     * @var mixed
     */
    public $PaymentRules;
    /**
     * The LocationDetails
     * Meta information extracted from the WSDL
     * - documentation: Detailed information about the associated rental facilities, for example, address, phone number, hours of operation.
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LocationDetails;
    /**
     * The TourInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TourInfo
     */
    public $TourInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for VehicleAvailVendorInfoType
     * @uses VehicleAvailVendorInfoType::setVendorMessages()
     * @uses VehicleAvailVendorInfoType::setOffLocServices()
     * @uses VehicleAvailVendorInfoType::setPaymentRules()
     * @uses VehicleAvailVendorInfoType::setLocationDetails()
     * @uses VehicleAvailVendorInfoType::setTourInfo()
     * @uses VehicleAvailVendorInfoType::setTPA_Extensions()
     * @param mixed $vendorMessages
     * @param mixed[] $offLocServices
     * @param mixed $paymentRules
     * @param mixed[] $locationDetails
     * @param \StructType\TourInfo $tourInfo
     * @param mixed $tPA_Extensions
     */
    public function __construct($vendorMessages = null, array $offLocServices = array(), $paymentRules = null, array $locationDetails = array(), \StructType\TourInfo $tourInfo = null, $tPA_Extensions = null)
    {
        $this
            ->setVendorMessages($vendorMessages)
            ->setOffLocServices($offLocServices)
            ->setPaymentRules($paymentRules)
            ->setLocationDetails($locationDetails)
            ->setTourInfo($tourInfo)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get VendorMessages value
     * @return mixed|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param mixed $vendorMessages
     * @return \StructType\VehicleAvailVendorInfoType
     */
    public function setVendorMessages($vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Get OffLocServices value
     * @return mixed[]|null
     */
    public function getOffLocServices()
    {
        return $this->OffLocServices;
    }
    /**
     * This method is responsible for validating the values passed to the setOffLocServices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffLocServices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOffLocServicesForArrayConstraintsFromSetOffLocServices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleAvailVendorInfoTypeOffLocServicesItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleAvailVendorInfoTypeOffLocServicesItem) ? get_class($vehicleAvailVendorInfoTypeOffLocServicesItem) : sprintf('%s(%s)', gettype($vehicleAvailVendorInfoTypeOffLocServicesItem), var_export($vehicleAvailVendorInfoTypeOffLocServicesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OffLocServices property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OffLocServices value
     * @throws \InvalidArgumentException
     * @param mixed[] $offLocServices
     * @return \StructType\VehicleAvailVendorInfoType
     */
    public function setOffLocServices(array $offLocServices = array())
    {
        // validation for constraint: array
        if ('' !== ($offLocServicesArrayErrorMessage = self::validateOffLocServicesForArrayConstraintsFromSetOffLocServices($offLocServices))) {
            throw new \InvalidArgumentException($offLocServicesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($offLocServices) && count($offLocServices) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($offLocServices)), __LINE__);
        }
        $this->OffLocServices = $offLocServices;
        return $this;
    }
    /**
     * Add item to OffLocServices value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleAvailVendorInfoType
     */
    public function addToOffLocServices($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The OffLocServices property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->OffLocServices) && count($this->OffLocServices) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->OffLocServices)), __LINE__);
        }
        $this->OffLocServices[] = $item;
        return $this;
    }
    /**
     * Get PaymentRules value
     * @return mixed|null
     */
    public function getPaymentRules()
    {
        return $this->PaymentRules;
    }
    /**
     * Set PaymentRules value
     * @param mixed $paymentRules
     * @return \StructType\VehicleAvailVendorInfoType
     */
    public function setPaymentRules($paymentRules = null)
    {
        $this->PaymentRules = $paymentRules;
        return $this;
    }
    /**
     * Get LocationDetails value
     * @return mixed[]|null
     */
    public function getLocationDetails()
    {
        return $this->LocationDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationDetailsForArrayConstraintsFromSetLocationDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleAvailVendorInfoTypeLocationDetailsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($vehicleAvailVendorInfoTypeLocationDetailsItem) ? get_class($vehicleAvailVendorInfoTypeLocationDetailsItem) : sprintf('%s(%s)', gettype($vehicleAvailVendorInfoTypeLocationDetailsItem), var_export($vehicleAvailVendorInfoTypeLocationDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LocationDetails property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LocationDetails value
     * @throws \InvalidArgumentException
     * @param mixed[] $locationDetails
     * @return \StructType\VehicleAvailVendorInfoType
     */
    public function setLocationDetails(array $locationDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($locationDetailsArrayErrorMessage = self::validateLocationDetailsForArrayConstraintsFromSetLocationDetails($locationDetails))) {
            throw new \InvalidArgumentException($locationDetailsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($locationDetails) && count($locationDetails) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($locationDetails)), __LINE__);
        }
        $this->LocationDetails = $locationDetails;
        return $this;
    }
    /**
     * Add item to LocationDetails value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\VehicleAvailVendorInfoType
     */
    public function addToLocationDetails($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LocationDetails property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->LocationDetails) && count($this->LocationDetails) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->LocationDetails)), __LINE__);
        }
        $this->LocationDetails[] = $item;
        return $this;
    }
    /**
     * Get TourInfo value
     * @return \StructType\TourInfo|null
     */
    public function getTourInfo()
    {
        return $this->TourInfo;
    }
    /**
     * Set TourInfo value
     * @param \StructType\TourInfo $tourInfo
     * @return \StructType\VehicleAvailVendorInfoType
     */
    public function setTourInfo(\StructType\TourInfo $tourInfo = null)
    {
        $this->TourInfo = $tourInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\VehicleAvailVendorInfoType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleAvailVendorInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
