<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailRQCoreType StructType
 * Meta information extracted from the WSDL
 * - documentation: Common information in a request for vehicle availability and rates.
 * @subpackage Structs
 */
class VehicleAvailRQCoreType extends AbstractStructBase
{
    /**
     * The VehRentalCore
     * Meta information extracted from the WSDL
     * - documentation: Core information.
     * @var mixed
     */
    public $VehRentalCore;
    /**
     * The MultimodalOffer
     * Meta information extracted from the WSDL
     * - documentation: Multimodal offer influencers.
     * - minOccurs: 0
     * @var mixed
     */
    public $MultimodalOffer;
    /**
     * The VendorPrefs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorPrefs
     */
    public $VendorPrefs;
    /**
     * The VehPrefs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehPrefs
     */
    public $VehPrefs;
    /**
     * The DriverType
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\DriverType[]
     */
    public $DriverType;
    /**
     * The RateQualifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 13
     * - minOccurs: 0
     * @var \StructType\RateQualifier[]
     */
    public $RateQualifier;
    /**
     * The RateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RateRange
     */
    public $RateRange;
    /**
     * The SpecialEquipPrefs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SpecialEquipPrefs
     */
    public $SpecialEquipPrefs;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: The status of the vehicle availability and/or rates are being requested for, e.g. available and waitlist.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The TargetSource
     * Meta information extracted from the WSDL
     * - documentation: To specify from which source the information being requested should be obtained, e.g., vendor, GDS system, etc.
     * - use: optional
     * @var string
     */
    public $TargetSource;
    /**
     * Constructor method for VehicleAvailRQCoreType
     * @uses VehicleAvailRQCoreType::setVehRentalCore()
     * @uses VehicleAvailRQCoreType::setMultimodalOffer()
     * @uses VehicleAvailRQCoreType::setVendorPrefs()
     * @uses VehicleAvailRQCoreType::setVehPrefs()
     * @uses VehicleAvailRQCoreType::setDriverType()
     * @uses VehicleAvailRQCoreType::setRateQualifier()
     * @uses VehicleAvailRQCoreType::setRateRange()
     * @uses VehicleAvailRQCoreType::setSpecialEquipPrefs()
     * @uses VehicleAvailRQCoreType::setTPA_Extensions()
     * @uses VehicleAvailRQCoreType::setStatus()
     * @uses VehicleAvailRQCoreType::setTargetSource()
     * @param mixed $vehRentalCore
     * @param mixed $multimodalOffer
     * @param \StructType\VendorPrefs $vendorPrefs
     * @param \StructType\VehPrefs $vehPrefs
     * @param \StructType\DriverType[] $driverType
     * @param \StructType\RateQualifier[] $rateQualifier
     * @param \StructType\RateRange $rateRange
     * @param \StructType\SpecialEquipPrefs $specialEquipPrefs
     * @param mixed $tPA_Extensions
     * @param string $status
     * @param string $targetSource
     */
    public function __construct($vehRentalCore = null, $multimodalOffer = null, \StructType\VendorPrefs $vendorPrefs = null, \StructType\VehPrefs $vehPrefs = null, array $driverType = array(), array $rateQualifier = array(), \StructType\RateRange $rateRange = null, \StructType\SpecialEquipPrefs $specialEquipPrefs = null, $tPA_Extensions = null, $status = null, $targetSource = null)
    {
        $this
            ->setVehRentalCore($vehRentalCore)
            ->setMultimodalOffer($multimodalOffer)
            ->setVendorPrefs($vendorPrefs)
            ->setVehPrefs($vehPrefs)
            ->setDriverType($driverType)
            ->setRateQualifier($rateQualifier)
            ->setRateRange($rateRange)
            ->setSpecialEquipPrefs($specialEquipPrefs)
            ->setTPA_Extensions($tPA_Extensions)
            ->setStatus($status)
            ->setTargetSource($targetSource);
    }
    /**
     * Get VehRentalCore value
     * @return mixed|null
     */
    public function getVehRentalCore()
    {
        return $this->VehRentalCore;
    }
    /**
     * Set VehRentalCore value
     * @param mixed $vehRentalCore
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setVehRentalCore($vehRentalCore = null)
    {
        $this->VehRentalCore = $vehRentalCore;
        return $this;
    }
    /**
     * Get MultimodalOffer value
     * @return mixed|null
     */
    public function getMultimodalOffer()
    {
        return $this->MultimodalOffer;
    }
    /**
     * Set MultimodalOffer value
     * @param mixed $multimodalOffer
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setMultimodalOffer($multimodalOffer = null)
    {
        $this->MultimodalOffer = $multimodalOffer;
        return $this;
    }
    /**
     * Get VendorPrefs value
     * @return \StructType\VendorPrefs|null
     */
    public function getVendorPrefs()
    {
        return $this->VendorPrefs;
    }
    /**
     * Set VendorPrefs value
     * @param \StructType\VendorPrefs $vendorPrefs
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setVendorPrefs(\StructType\VendorPrefs $vendorPrefs = null)
    {
        $this->VendorPrefs = $vendorPrefs;
        return $this;
    }
    /**
     * Get VehPrefs value
     * @return \StructType\VehPrefs|null
     */
    public function getVehPrefs()
    {
        return $this->VehPrefs;
    }
    /**
     * Set VehPrefs value
     * @param \StructType\VehPrefs $vehPrefs
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setVehPrefs(\StructType\VehPrefs $vehPrefs = null)
    {
        $this->VehPrefs = $vehPrefs;
        return $this;
    }
    /**
     * Get DriverType value
     * @return \StructType\DriverType[]|null
     */
    public function getDriverType()
    {
        return $this->DriverType;
    }
    /**
     * This method is responsible for validating the values passed to the setDriverType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDriverType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDriverTypeForArrayConstraintsFromSetDriverType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleAvailRQCoreTypeDriverTypeItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailRQCoreTypeDriverTypeItem instanceof \StructType\DriverType) {
                $invalidValues[] = is_object($vehicleAvailRQCoreTypeDriverTypeItem) ? get_class($vehicleAvailRQCoreTypeDriverTypeItem) : sprintf('%s(%s)', gettype($vehicleAvailRQCoreTypeDriverTypeItem), var_export($vehicleAvailRQCoreTypeDriverTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DriverType property can only contain items of type \StructType\DriverType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DriverType value
     * @throws \InvalidArgumentException
     * @param \StructType\DriverType[] $driverType
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setDriverType(array $driverType = array())
    {
        // validation for constraint: array
        if ('' !== ($driverTypeArrayErrorMessage = self::validateDriverTypeForArrayConstraintsFromSetDriverType($driverType))) {
            throw new \InvalidArgumentException($driverTypeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($driverType) && count($driverType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($driverType)), __LINE__);
        }
        $this->DriverType = $driverType;
        return $this;
    }
    /**
     * Add item to DriverType value
     * @throws \InvalidArgumentException
     * @param \StructType\DriverType $item
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function addToDriverType(\StructType\DriverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DriverType) {
            throw new \InvalidArgumentException(sprintf('The DriverType property can only contain items of type \StructType\DriverType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->DriverType) && count($this->DriverType) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->DriverType)), __LINE__);
        }
        $this->DriverType[] = $item;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \StructType\RateQualifier[]|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * This method is responsible for validating the values passed to the setRateQualifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateQualifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateQualifierForArrayConstraintsFromSetRateQualifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleAvailRQCoreTypeRateQualifierItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailRQCoreTypeRateQualifierItem instanceof \StructType\RateQualifier) {
                $invalidValues[] = is_object($vehicleAvailRQCoreTypeRateQualifierItem) ? get_class($vehicleAvailRQCoreTypeRateQualifierItem) : sprintf('%s(%s)', gettype($vehicleAvailRQCoreTypeRateQualifierItem), var_export($vehicleAvailRQCoreTypeRateQualifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateQualifier property can only contain items of type \StructType\RateQualifier, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateQualifier value
     * @throws \InvalidArgumentException
     * @param \StructType\RateQualifier[] $rateQualifier
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setRateQualifier(array $rateQualifier = array())
    {
        // validation for constraint: array
        if ('' !== ($rateQualifierArrayErrorMessage = self::validateRateQualifierForArrayConstraintsFromSetRateQualifier($rateQualifier))) {
            throw new \InvalidArgumentException($rateQualifierArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(13)
        if (is_array($rateQualifier) && count($rateQualifier) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 13', count($rateQualifier)), __LINE__);
        }
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Add item to RateQualifier value
     * @throws \InvalidArgumentException
     * @param \StructType\RateQualifier $item
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function addToRateQualifier(\StructType\RateQualifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateQualifier) {
            throw new \InvalidArgumentException(sprintf('The RateQualifier property can only contain items of type \StructType\RateQualifier, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(13)
        if (is_array($this->RateQualifier) && count($this->RateQualifier) >= 13) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 13', count($this->RateQualifier)), __LINE__);
        }
        $this->RateQualifier[] = $item;
        return $this;
    }
    /**
     * Get RateRange value
     * @return \StructType\RateRange|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * Set RateRange value
     * @param \StructType\RateRange $rateRange
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setRateRange(\StructType\RateRange $rateRange = null)
    {
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Get SpecialEquipPrefs value
     * @return \StructType\SpecialEquipPrefs|null
     */
    public function getSpecialEquipPrefs()
    {
        return $this->SpecialEquipPrefs;
    }
    /**
     * Set SpecialEquipPrefs value
     * @param \StructType\SpecialEquipPrefs $specialEquipPrefs
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setSpecialEquipPrefs(\StructType\SpecialEquipPrefs $specialEquipPrefs = null)
    {
        $this->SpecialEquipPrefs = $specialEquipPrefs;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\InventoryStatusType::valueIsValid()
     * @uses \EnumType\InventoryStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InventoryStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InventoryStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\InventoryStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TargetSource value
     * @return string|null
     */
    public function getTargetSource()
    {
        return $this->TargetSource;
    }
    /**
     * Set TargetSource value
     * @param string $targetSource
     * @return \StructType\VehicleAvailRQCoreType
     */
    public function setTargetSource($targetSource = null)
    {
        // validation for constraint: string
        if (!is_null($targetSource) && !is_string($targetSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetSource, true), gettype($targetSource)), __LINE__);
        }
        $this->TargetSource = $targetSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleAvailRQCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
