<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehPrefs StructType
 * Meta information extracted from the WSDL
 * - documentation: Vehicle preferences.
 * @subpackage Structs
 */
class VehPrefs extends AbstractStructBase
{
    /**
     * The VehPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\VehPref[]
     */
    public $VehPref;
    /**
     * Constructor method for VehPrefs
     * @uses VehPrefs::setVehPref()
     * @param \StructType\VehPref[] $vehPref
     */
    public function __construct(array $vehPref = array())
    {
        $this
            ->setVehPref($vehPref);
    }
    /**
     * Get VehPref value
     * @return \StructType\VehPref[]|null
     */
    public function getVehPref()
    {
        return $this->VehPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVehPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehPrefForArrayConstraintsFromSetVehPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehPrefsVehPrefItem) {
            // validation for constraint: itemType
            if (!$vehPrefsVehPrefItem instanceof \StructType\VehPref) {
                $invalidValues[] = is_object($vehPrefsVehPrefItem) ? get_class($vehPrefsVehPrefItem) : sprintf('%s(%s)', gettype($vehPrefsVehPrefItem), var_export($vehPrefsVehPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehPref property can only contain items of type \StructType\VehPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehPref[] $vehPref
     * @return \StructType\VehPrefs
     */
    public function setVehPref(array $vehPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vehPrefArrayErrorMessage = self::validateVehPrefForArrayConstraintsFromSetVehPref($vehPref))) {
            throw new \InvalidArgumentException($vehPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($vehPref) && count($vehPref) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($vehPref)), __LINE__);
        }
        $this->VehPref = $vehPref;
        return $this;
    }
    /**
     * Add item to VehPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehPref $item
     * @return \StructType\VehPrefs
     */
    public function addToVehPref(\StructType\VehPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehPref) {
            throw new \InvalidArgumentException(sprintf('The VehPref property can only contain items of type \StructType\VehPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->VehPref) && count($this->VehPref) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->VehPref)), __LINE__);
        }
        $this->VehPref[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehPrefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
