<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehAvails StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of vehicles along with their availability and associated rate information.
 * @subpackage Structs
 */
class VehAvails extends AbstractStructBase
{
    /**
     * The VehAvail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\VehAvail[]
     */
    public $VehAvail;
    /**
     * The RateCategory
     * Meta information extracted from the WSDL
     * - documentation: The rate category for all the vehicles available. Refer to OpenTravel Code List Rate Category (RTC).
     * - use: optional
     * @var string
     */
    public $RateCategory;
    /**
     * The RatePeriod
     * Meta information extracted from the WSDL
     * - documentation: The rate period for all the vehicles available.
     * - use: optional
     * @var string
     */
    public $RatePeriod;
    /**
     * Constructor method for VehAvails
     * @uses VehAvails::setVehAvail()
     * @uses VehAvails::setRateCategory()
     * @uses VehAvails::setRatePeriod()
     * @param \StructType\VehAvail[] $vehAvail
     * @param string $rateCategory
     * @param string $ratePeriod
     */
    public function __construct(array $vehAvail = array(), $rateCategory = null, $ratePeriod = null)
    {
        $this
            ->setVehAvail($vehAvail)
            ->setRateCategory($rateCategory)
            ->setRatePeriod($ratePeriod);
    }
    /**
     * Get VehAvail value
     * @return \StructType\VehAvail[]|null
     */
    public function getVehAvail()
    {
        return $this->VehAvail;
    }
    /**
     * This method is responsible for validating the values passed to the setVehAvail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehAvail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehAvailForArrayConstraintsFromSetVehAvail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehAvailsVehAvailItem) {
            // validation for constraint: itemType
            if (!$vehAvailsVehAvailItem instanceof \StructType\VehAvail) {
                $invalidValues[] = is_object($vehAvailsVehAvailItem) ? get_class($vehAvailsVehAvailItem) : sprintf('%s(%s)', gettype($vehAvailsVehAvailItem), var_export($vehAvailsVehAvailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehAvail property can only contain items of type \StructType\VehAvail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\VehAvail[] $vehAvail
     * @return \StructType\VehAvails
     */
    public function setVehAvail(array $vehAvail = array())
    {
        // validation for constraint: array
        if ('' !== ($vehAvailArrayErrorMessage = self::validateVehAvailForArrayConstraintsFromSetVehAvail($vehAvail))) {
            throw new \InvalidArgumentException($vehAvailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vehAvail) && count($vehAvail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vehAvail)), __LINE__);
        }
        $this->VehAvail = $vehAvail;
        return $this;
    }
    /**
     * Add item to VehAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\VehAvail $item
     * @return \StructType\VehAvails
     */
    public function addToVehAvail(\StructType\VehAvail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehAvail) {
            throw new \InvalidArgumentException(sprintf('The VehAvail property can only contain items of type \StructType\VehAvail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->VehAvail) && count($this->VehAvail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->VehAvail)), __LINE__);
        }
        $this->VehAvail[] = $item;
        return $this;
    }
    /**
     * Get RateCategory value
     * @return string|null
     */
    public function getRateCategory()
    {
        return $this->RateCategory;
    }
    /**
     * Set RateCategory value
     * @param string $rateCategory
     * @return \StructType\VehAvails
     */
    public function setRateCategory($rateCategory = null)
    {
        // validation for constraint: string
        if (!is_null($rateCategory) && !is_string($rateCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateCategory, true), gettype($rateCategory)), __LINE__);
        }
        $this->RateCategory = $rateCategory;
        return $this;
    }
    /**
     * Get RatePeriod value
     * @return string|null
     */
    public function getRatePeriod()
    {
        return $this->RatePeriod;
    }
    /**
     * Set RatePeriod value
     * @uses \EnumType\RatePeriodSimpleType::valueIsValid()
     * @uses \EnumType\RatePeriodSimpleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ratePeriod
     * @return \StructType\VehAvails
     */
    public function setRatePeriod($ratePeriod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RatePeriodSimpleType::valueIsValid($ratePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RatePeriodSimpleType', is_array($ratePeriod) ? implode(', ', $ratePeriod) : var_export($ratePeriod, true), implode(', ', \EnumType\RatePeriodSimpleType::getValidValues())), __LINE__);
        }
        $this->RatePeriod = $ratePeriod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehAvails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
