<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Usage StructType
 * Meta information extracted from the WSDL
 * - documentation: Power usage detail.
 * - use: optional
 * @subpackage Structs
 */
class Usage extends AbstractStructBase
{
    /**
     * The PowerType
     * Meta information extracted from the WSDL
     * - documentation: Example: Electric | Power type.
     * - minOccurs: 0
     * @var mixed
     */
    public $PowerType;
    /**
     * The PowerTypeUOM
     * Meta information extracted from the WSDL
     * - documentation: Example: Killowatt(s) | Power quantity unit of measure.
     * - minOccurs: 0
     * @var mixed
     */
    public $PowerTypeUOM;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Example: 677 | Power amount.
     * - use: optional
     * @var float
     */
    public $Quantity;
    /**
     * Constructor method for Usage
     * @uses Usage::setPowerType()
     * @uses Usage::setPowerTypeUOM()
     * @uses Usage::setQuantity()
     * @param mixed $powerType
     * @param mixed $powerTypeUOM
     * @param float $quantity
     */
    public function __construct($powerType = null, $powerTypeUOM = null, $quantity = null)
    {
        $this
            ->setPowerType($powerType)
            ->setPowerTypeUOM($powerTypeUOM)
            ->setQuantity($quantity);
    }
    /**
     * Get PowerType value
     * @return mixed|null
     */
    public function getPowerType()
    {
        return $this->PowerType;
    }
    /**
     * Set PowerType value
     * @param mixed $powerType
     * @return \StructType\Usage
     */
    public function setPowerType($powerType = null)
    {
        $this->PowerType = $powerType;
        return $this;
    }
    /**
     * Get PowerTypeUOM value
     * @return mixed|null
     */
    public function getPowerTypeUOM()
    {
        return $this->PowerTypeUOM;
    }
    /**
     * Set PowerTypeUOM value
     * @param mixed $powerTypeUOM
     * @return \StructType\Usage
     */
    public function setPowerTypeUOM($powerTypeUOM = null)
    {
        $this->PowerTypeUOM = $powerTypeUOM;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Usage
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Usage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
