<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Upgrade StructType
 * Meta information extracted from the WSDL
 * - documentation: Upgrade instruction information.
 * @subpackage Structs
 */
class Upgrade extends AbstractStructBase
{
    /**
     * The Instruction
     * Meta information extracted from the WSDL
     * - documentation: Upgrade instruction text.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Instruction;
    /**
     * The UpgradeMethod
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $UpgradeMethod;
    /**
     * The UpgradeDesigCode
     * Meta information extracted from the WSDL
     * - documentation: The upgrade booking class.
     * - use: optional
     * @var string
     */
    public $UpgradeDesigCode;
    /**
     * Constructor method for Upgrade
     * @uses Upgrade::setInstruction()
     * @uses Upgrade::setUpgradeMethod()
     * @uses Upgrade::setUpgradeDesigCode()
     * @param string[] $instruction
     * @param string $upgradeMethod
     * @param string $upgradeDesigCode
     */
    public function __construct(array $instruction = array(), $upgradeMethod = null, $upgradeDesigCode = null)
    {
        $this
            ->setInstruction($instruction)
            ->setUpgradeMethod($upgradeMethod)
            ->setUpgradeDesigCode($upgradeDesigCode);
    }
    /**
     * Get Instruction value
     * @return string[]|null
     */
    public function getInstruction()
    {
        return $this->Instruction;
    }
    /**
     * This method is responsible for validating the values passed to the setInstruction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstruction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionForArrayConstraintsFromSetInstruction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $upgradeInstructionItem) {
            // validation for constraint: itemType
            if (!is_string($upgradeInstructionItem)) {
                $invalidValues[] = is_object($upgradeInstructionItem) ? get_class($upgradeInstructionItem) : sprintf('%s(%s)', gettype($upgradeInstructionItem), var_export($upgradeInstructionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Instruction property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Instruction value
     * @throws \InvalidArgumentException
     * @param string[] $instruction
     * @return \StructType\Upgrade
     */
    public function setInstruction(array $instruction = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionArrayErrorMessage = self::validateInstructionForArrayConstraintsFromSetInstruction($instruction))) {
            throw new \InvalidArgumentException($instructionArrayErrorMessage, __LINE__);
        }
        $this->Instruction = $instruction;
        return $this;
    }
    /**
     * Add item to Instruction value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Upgrade
     */
    public function addToInstruction($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Instruction property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Instruction[] = $item;
        return $this;
    }
    /**
     * Get UpgradeMethod value
     * @return string|null
     */
    public function getUpgradeMethod()
    {
        return $this->UpgradeMethod;
    }
    /**
     * Set UpgradeMethod value
     * @param string $upgradeMethod
     * @return \StructType\Upgrade
     */
    public function setUpgradeMethod($upgradeMethod = null)
    {
        // validation for constraint: string
        if (!is_null($upgradeMethod) && !is_string($upgradeMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upgradeMethod, true), gettype($upgradeMethod)), __LINE__);
        }
        $this->UpgradeMethod = $upgradeMethod;
        return $this;
    }
    /**
     * Get UpgradeDesigCode value
     * @return string|null
     */
    public function getUpgradeDesigCode()
    {
        return $this->UpgradeDesigCode;
    }
    /**
     * Set UpgradeDesigCode value
     * @param string $upgradeDesigCode
     * @return \StructType\Upgrade
     */
    public function setUpgradeDesigCode($upgradeDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($upgradeDesigCode) && !is_string($upgradeDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upgradeDesigCode, true), gettype($upgradeDesigCode)), __LINE__);
        }
        $this->UpgradeDesigCode = $upgradeDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Upgrade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
