<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnticketedPointInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Unticketed information, including city airport code and arrival/ departure dates.
 * @subpackage Structs
 */
class UnticketedPointInfo extends AbstractStructBase
{
    /**
     * The CityAirportCode
     * Meta information extracted from the WSDL
     * - documentation: The airport or city code identifying an unticketed point which occurs between the coupon origin and destination.
     * - use: optional
     * @var string
     */
    public $CityAirportCode;
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - documentation: The date and time of arrival in GMT at the unticketed point.
     * - use: optional
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: The date and time of depature in GMT from the unticketed point.
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * The AirEquipType
     * Meta information extracted from the WSDL
     * - documentation: The standard code of the quipment used for the coupon flight departing from the unticketed point.
     * - use: optional
     * @var string
     */
    public $AirEquipType;
    /**
     * Constructor method for UnticketedPointInfo
     * @uses UnticketedPointInfo::setCityAirportCode()
     * @uses UnticketedPointInfo::setArrivalDate()
     * @uses UnticketedPointInfo::setDepartureDate()
     * @uses UnticketedPointInfo::setAirEquipType()
     * @param string $cityAirportCode
     * @param string $arrivalDate
     * @param string $departureDate
     * @param string $airEquipType
     */
    public function __construct($cityAirportCode = null, $arrivalDate = null, $departureDate = null, $airEquipType = null)
    {
        $this
            ->setCityAirportCode($cityAirportCode)
            ->setArrivalDate($arrivalDate)
            ->setDepartureDate($departureDate)
            ->setAirEquipType($airEquipType);
    }
    /**
     * Get CityAirportCode value
     * @return string|null
     */
    public function getCityAirportCode()
    {
        return $this->CityAirportCode;
    }
    /**
     * Set CityAirportCode value
     * @param string $cityAirportCode
     * @return \StructType\UnticketedPointInfo
     */
    public function setCityAirportCode($cityAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityAirportCode) && !is_string($cityAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityAirportCode, true), gettype($cityAirportCode)), __LINE__);
        }
        $this->CityAirportCode = $cityAirportCode;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\UnticketedPointInfo
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\UnticketedPointInfo
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get AirEquipType value
     * @return string|null
     */
    public function getAirEquipType()
    {
        return $this->AirEquipType;
    }
    /**
     * Set AirEquipType value
     * @param string $airEquipType
     * @return \StructType\UnticketedPointInfo
     */
    public function setAirEquipType($airEquipType = null)
    {
        // validation for constraint: string
        if (!is_null($airEquipType) && !is_string($airEquipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airEquipType, true), gettype($airEquipType)), __LINE__);
        }
        $this->AirEquipType = $airEquipType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnticketedPointInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
