<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripCharacteristics StructType
 * Meta information extracted from the WSDL
 * - documentation: Note: All of this information pertains to the trip component that has been accommodated by the offer requestor. | Existing trip characteristics.
 * @subpackage Structs
 */
class TripCharacteristics extends AbstractStructBase
{
    /**
     * The Mode
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the trip mode that has been accommodated by the offer requestor, e.g. the mode that serves as the basis for all information in this subsequent offer request. | Example: Flight | Requestor trip mode.
     * @var mixed
     */
    public $Mode;
    /**
     * The BookingMethod
     * Meta information extracted from the WSDL
     * - documentation: Reservation booking method.
     * - minOccurs: 0
     * @var mixed
     */
    public $BookingMethod;
    /**
     * The DateTimeDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateTimeDuration
     */
    public $DateTimeDuration;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Location[]
     */
    public $Location;
    /**
     * The PriceAndPayment
     * Meta information extracted from the WSDL
     * - documentation: Price and payment details.
     * - minOccurs: 0
     * @var mixed
     */
    public $PriceAndPayment;
    /**
     * The ReservationStatus
     * Meta information extracted from the WSDL
     * - documentation: Reservation status.
     * - minOccurs: 0
     * @var mixed
     */
    public $ReservationStatus;
    /**
     * The Baggage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Baggage
     */
    public $Baggage;
    /**
     * The Animals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Animals
     */
    public $Animals;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - documentation: Activity related trip mode information.
     * - minOccurs: 0
     * @var mixed
     */
    public $Activity;
    /**
     * The Lodging
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Lodging
     */
    public $Lodging;
    /**
     * The Transportation
     * Meta information extracted from the WSDL
     * - documentation: Transportation trip mode information.
     * - minOccurs: 0
     * @var mixed
     */
    public $Transportation;
    /**
     * The TripValue
     * Meta information extracted from the WSDL
     * - documentation: Offer requestor assessed trip value.
     * - minOccurs: 0
     * @var mixed
     */
    public $TripValue;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for TripCharacteristics
     * @uses TripCharacteristics::setMode()
     * @uses TripCharacteristics::setBookingMethod()
     * @uses TripCharacteristics::setDateTimeDuration()
     * @uses TripCharacteristics::setLocation()
     * @uses TripCharacteristics::setPriceAndPayment()
     * @uses TripCharacteristics::setReservationStatus()
     * @uses TripCharacteristics::setBaggage()
     * @uses TripCharacteristics::setAnimals()
     * @uses TripCharacteristics::setActivity()
     * @uses TripCharacteristics::setLodging()
     * @uses TripCharacteristics::setTransportation()
     * @uses TripCharacteristics::setTripValue()
     * @uses TripCharacteristics::setOntologyExtension()
     * @param mixed $mode
     * @param mixed $bookingMethod
     * @param \StructType\DateTimeDuration $dateTimeDuration
     * @param \StructType\Location[] $location
     * @param mixed $priceAndPayment
     * @param mixed $reservationStatus
     * @param \StructType\Baggage $baggage
     * @param \StructType\Animals $animals
     * @param mixed $activity
     * @param \StructType\Lodging $lodging
     * @param mixed $transportation
     * @param mixed $tripValue
     * @param mixed $ontologyExtension
     */
    public function __construct($mode = null, $bookingMethod = null, \StructType\DateTimeDuration $dateTimeDuration = null, array $location = array(), $priceAndPayment = null, $reservationStatus = null, \StructType\Baggage $baggage = null, \StructType\Animals $animals = null, $activity = null, \StructType\Lodging $lodging = null, $transportation = null, $tripValue = null, $ontologyExtension = null)
    {
        $this
            ->setMode($mode)
            ->setBookingMethod($bookingMethod)
            ->setDateTimeDuration($dateTimeDuration)
            ->setLocation($location)
            ->setPriceAndPayment($priceAndPayment)
            ->setReservationStatus($reservationStatus)
            ->setBaggage($baggage)
            ->setAnimals($animals)
            ->setActivity($activity)
            ->setLodging($lodging)
            ->setTransportation($transportation)
            ->setTripValue($tripValue)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get Mode value
     * @return mixed|null
     */
    public function getMode()
    {
        return $this->Mode;
    }
    /**
     * Set Mode value
     * @param mixed $mode
     * @return \StructType\TripCharacteristics
     */
    public function setMode($mode = null)
    {
        $this->Mode = $mode;
        return $this;
    }
    /**
     * Get BookingMethod value
     * @return mixed|null
     */
    public function getBookingMethod()
    {
        return $this->BookingMethod;
    }
    /**
     * Set BookingMethod value
     * @param mixed $bookingMethod
     * @return \StructType\TripCharacteristics
     */
    public function setBookingMethod($bookingMethod = null)
    {
        $this->BookingMethod = $bookingMethod;
        return $this;
    }
    /**
     * Get DateTimeDuration value
     * @return \StructType\DateTimeDuration|null
     */
    public function getDateTimeDuration()
    {
        return $this->DateTimeDuration;
    }
    /**
     * Set DateTimeDuration value
     * @param \StructType\DateTimeDuration $dateTimeDuration
     * @return \StructType\TripCharacteristics
     */
    public function setDateTimeDuration(\StructType\DateTimeDuration $dateTimeDuration = null)
    {
        $this->DateTimeDuration = $dateTimeDuration;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Location[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tripCharacteristicsLocationItem) {
            // validation for constraint: itemType
            if (!$tripCharacteristicsLocationItem instanceof \StructType\Location) {
                $invalidValues[] = is_object($tripCharacteristicsLocationItem) ? get_class($tripCharacteristicsLocationItem) : sprintf('%s(%s)', gettype($tripCharacteristicsLocationItem), var_export($tripCharacteristicsLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location property can only contain items of type \StructType\Location, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location[] $location
     * @return \StructType\TripCharacteristics
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new \InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param \StructType\Location $item
     * @return \StructType\TripCharacteristics
     */
    public function addToLocation(\StructType\Location $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Location) {
            throw new \InvalidArgumentException(sprintf('The Location property can only contain items of type \StructType\Location, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Get PriceAndPayment value
     * @return mixed|null
     */
    public function getPriceAndPayment()
    {
        return $this->PriceAndPayment;
    }
    /**
     * Set PriceAndPayment value
     * @param mixed $priceAndPayment
     * @return \StructType\TripCharacteristics
     */
    public function setPriceAndPayment($priceAndPayment = null)
    {
        $this->PriceAndPayment = $priceAndPayment;
        return $this;
    }
    /**
     * Get ReservationStatus value
     * @return mixed|null
     */
    public function getReservationStatus()
    {
        return $this->ReservationStatus;
    }
    /**
     * Set ReservationStatus value
     * @param mixed $reservationStatus
     * @return \StructType\TripCharacteristics
     */
    public function setReservationStatus($reservationStatus = null)
    {
        $this->ReservationStatus = $reservationStatus;
        return $this;
    }
    /**
     * Get Baggage value
     * @return \StructType\Baggage|null
     */
    public function getBaggage()
    {
        return $this->Baggage;
    }
    /**
     * Set Baggage value
     * @param \StructType\Baggage $baggage
     * @return \StructType\TripCharacteristics
     */
    public function setBaggage(\StructType\Baggage $baggage = null)
    {
        $this->Baggage = $baggage;
        return $this;
    }
    /**
     * Get Animals value
     * @return \StructType\Animals|null
     */
    public function getAnimals()
    {
        return $this->Animals;
    }
    /**
     * Set Animals value
     * @param \StructType\Animals $animals
     * @return \StructType\TripCharacteristics
     */
    public function setAnimals(\StructType\Animals $animals = null)
    {
        $this->Animals = $animals;
        return $this;
    }
    /**
     * Get Activity value
     * @return mixed|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param mixed $activity
     * @return \StructType\TripCharacteristics
     */
    public function setActivity($activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Lodging value
     * @return \StructType\Lodging|null
     */
    public function getLodging()
    {
        return $this->Lodging;
    }
    /**
     * Set Lodging value
     * @param \StructType\Lodging $lodging
     * @return \StructType\TripCharacteristics
     */
    public function setLodging(\StructType\Lodging $lodging = null)
    {
        $this->Lodging = $lodging;
        return $this;
    }
    /**
     * Get Transportation value
     * @return mixed|null
     */
    public function getTransportation()
    {
        return $this->Transportation;
    }
    /**
     * Set Transportation value
     * @param mixed $transportation
     * @return \StructType\TripCharacteristics
     */
    public function setTransportation($transportation = null)
    {
        $this->Transportation = $transportation;
        return $this;
    }
    /**
     * Get TripValue value
     * @return mixed|null
     */
    public function getTripValue()
    {
        return $this->TripValue;
    }
    /**
     * Set TripValue value
     * @param mixed $tripValue
     * @return \StructType\TripCharacteristics
     */
    public function setTripValue($tripValue = null)
    {
        $this->TripValue = $tripValue;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\TripCharacteristics
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripCharacteristics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
