<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the type of transportation offered.
 * @subpackage Structs
 */
class TransportationType extends AbstractStructBase
{
    /**
     * The Transportation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Transportation[]
     */
    public $Transportation;
    /**
     * Constructor method for TransportationType
     * @uses TransportationType::setTransportation()
     * @param \StructType\Transportation[] $transportation
     */
    public function __construct(array $transportation = array())
    {
        $this
            ->setTransportation($transportation);
    }
    /**
     * Get Transportation value
     * @return \StructType\Transportation[]|null
     */
    public function getTransportation()
    {
        return $this->Transportation;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportationForArrayConstraintsFromSetTransportation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportationTypeTransportationItem) {
            // validation for constraint: itemType
            if (!$transportationTypeTransportationItem instanceof \StructType\Transportation) {
                $invalidValues[] = is_object($transportationTypeTransportationItem) ? get_class($transportationTypeTransportationItem) : sprintf('%s(%s)', gettype($transportationTypeTransportationItem), var_export($transportationTypeTransportationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transportation property can only contain items of type \StructType\Transportation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transportation value
     * @throws \InvalidArgumentException
     * @param \StructType\Transportation[] $transportation
     * @return \StructType\TransportationType
     */
    public function setTransportation(array $transportation = array())
    {
        // validation for constraint: array
        if ('' !== ($transportationArrayErrorMessage = self::validateTransportationForArrayConstraintsFromSetTransportation($transportation))) {
            throw new \InvalidArgumentException($transportationArrayErrorMessage, __LINE__);
        }
        $this->Transportation = $transportation;
        return $this;
    }
    /**
     * Add item to Transportation value
     * @throws \InvalidArgumentException
     * @param \StructType\Transportation $item
     * @return \StructType\TransportationType
     */
    public function addToTransportation(\StructType\Transportation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transportation) {
            throw new \InvalidArgumentException(sprintf('The Transportation property can only contain items of type \StructType\Transportation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transportation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
