<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates preferences for certain types of transfer, such as connections or stopovers, when used for a specific travel situation. | Train characteristic preferences.
 * @subpackage Structs
 */
class TrainPref extends AbstractStructBase
{
    /**
     * The TransportModesPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\TransportModesPref[]
     */
    public $TransportModesPref;
    /**
     * Constructor method for TrainPref
     * @uses TrainPref::setTransportModesPref()
     * @param \StructType\TransportModesPref[] $transportModesPref
     */
    public function __construct(array $transportModesPref = array())
    {
        $this
            ->setTransportModesPref($transportModesPref);
    }
    /**
     * Get TransportModesPref value
     * @return \StructType\TransportModesPref[]|null
     */
    public function getTransportModesPref()
    {
        return $this->TransportModesPref;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportModesPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportModesPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportModesPrefForArrayConstraintsFromSetTransportModesPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trainPrefTransportModesPrefItem) {
            // validation for constraint: itemType
            if (!$trainPrefTransportModesPrefItem instanceof \StructType\TransportModesPref) {
                $invalidValues[] = is_object($trainPrefTransportModesPrefItem) ? get_class($trainPrefTransportModesPrefItem) : sprintf('%s(%s)', gettype($trainPrefTransportModesPrefItem), var_export($trainPrefTransportModesPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportModesPref property can only contain items of type \StructType\TransportModesPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportModesPref value
     * @throws \InvalidArgumentException
     * @param \StructType\TransportModesPref[] $transportModesPref
     * @return \StructType\TrainPref
     */
    public function setTransportModesPref(array $transportModesPref = array())
    {
        // validation for constraint: array
        if ('' !== ($transportModesPrefArrayErrorMessage = self::validateTransportModesPrefForArrayConstraintsFromSetTransportModesPref($transportModesPref))) {
            throw new \InvalidArgumentException($transportModesPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($transportModesPref) && count($transportModesPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($transportModesPref)), __LINE__);
        }
        $this->TransportModesPref = $transportModesPref;
        return $this;
    }
    /**
     * Add item to TransportModesPref value
     * @throws \InvalidArgumentException
     * @param \StructType\TransportModesPref $item
     * @return \StructType\TrainPref
     */
    public function addToTransportModesPref(\StructType\TransportModesPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransportModesPref) {
            throw new \InvalidArgumentException(sprintf('The TransportModesPref property can only contain items of type \StructType\TransportModesPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->TransportModesPref) && count($this->TransportModesPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->TransportModesPref)), __LINE__);
        }
        $this->TransportModesPref[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrainPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
