<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines train Information.
 * @subpackage Structs
 */
class TrainInfoType extends AbstractStructBase
{
    /**
     * The Train
     * Meta information extracted from the WSDL
     * - documentation: Identification and classification information of the train.
     * @var mixed
     */
    public $Train;
    /**
     * The ValidDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ValidDate
     */
    public $ValidDate;
    /**
     * The DelayTime
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DelayTime;
    /**
     * The ScheduleCode
     * Meta information extracted from the WSDL
     * - documentation: The schedule code for the train. Refer to OpenTravel code list Train Schedule Code (TSC).
     * - use: optional
     * @var string
     */
    public $ScheduleCode;
    /**
     * Constructor method for TrainInfoType
     * @uses TrainInfoType::setTrain()
     * @uses TrainInfoType::setValidDate()
     * @uses TrainInfoType::setDelayTime()
     * @uses TrainInfoType::setScheduleCode()
     * @param mixed $train
     * @param \StructType\ValidDate $validDate
     * @param string $delayTime
     * @param string $scheduleCode
     */
    public function __construct($train = null, \StructType\ValidDate $validDate = null, $delayTime = null, $scheduleCode = null)
    {
        $this
            ->setTrain($train)
            ->setValidDate($validDate)
            ->setDelayTime($delayTime)
            ->setScheduleCode($scheduleCode);
    }
    /**
     * Get Train value
     * @return mixed|null
     */
    public function getTrain()
    {
        return $this->Train;
    }
    /**
     * Set Train value
     * @param mixed $train
     * @return \StructType\TrainInfoType
     */
    public function setTrain($train = null)
    {
        $this->Train = $train;
        return $this;
    }
    /**
     * Get ValidDate value
     * @return \StructType\ValidDate|null
     */
    public function getValidDate()
    {
        return $this->ValidDate;
    }
    /**
     * Set ValidDate value
     * @param \StructType\ValidDate $validDate
     * @return \StructType\TrainInfoType
     */
    public function setValidDate(\StructType\ValidDate $validDate = null)
    {
        $this->ValidDate = $validDate;
        return $this;
    }
    /**
     * Get DelayTime value
     * @return string|null
     */
    public function getDelayTime()
    {
        return $this->DelayTime;
    }
    /**
     * Set DelayTime value
     * @param string $delayTime
     * @return \StructType\TrainInfoType
     */
    public function setDelayTime($delayTime = null)
    {
        // validation for constraint: string
        if (!is_null($delayTime) && !is_string($delayTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delayTime, true), gettype($delayTime)), __LINE__);
        }
        $this->DelayTime = $delayTime;
        return $this;
    }
    /**
     * Get ScheduleCode value
     * @return string|null
     */
    public function getScheduleCode()
    {
        return $this->ScheduleCode;
    }
    /**
     * Set ScheduleCode value
     * @param string $scheduleCode
     * @return \StructType\TrainInfoType
     */
    public function setScheduleCode($scheduleCode = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleCode) && !is_string($scheduleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleCode, true), gettype($scheduleCode)), __LINE__);
        }
        $this->ScheduleCode = $scheduleCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrainInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
