<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainIdentificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines train identification information, including a train number and a train network code.
 * @subpackage Structs
 */
class TrainIdentificationType extends AbstractStructBase
{
    /**
     * The TrainNumber
     * Meta information extracted from the WSDL
     * - documentation: The unique number that identifies the train.
     * @var mixed
     */
    public $TrainNumber;
    /**
     * The NetworkCode
     * Meta information extracted from the WSDL
     * - documentation: The network code of a rail operator defined by UIC (International Union of Railways.)
     * - minOccurs: 0
     * @var mixed
     */
    public $NetworkCode;
    /**
     * Constructor method for TrainIdentificationType
     * @uses TrainIdentificationType::setTrainNumber()
     * @uses TrainIdentificationType::setNetworkCode()
     * @param mixed $trainNumber
     * @param mixed $networkCode
     */
    public function __construct($trainNumber = null, $networkCode = null)
    {
        $this
            ->setTrainNumber($trainNumber)
            ->setNetworkCode($networkCode);
    }
    /**
     * Get TrainNumber value
     * @return mixed|null
     */
    public function getTrainNumber()
    {
        return $this->TrainNumber;
    }
    /**
     * Set TrainNumber value
     * @param mixed $trainNumber
     * @return \StructType\TrainIdentificationType
     */
    public function setTrainNumber($trainNumber = null)
    {
        $this->TrainNumber = $trainNumber;
        return $this;
    }
    /**
     * Get NetworkCode value
     * @return mixed|null
     */
    public function getNetworkCode()
    {
        return $this->NetworkCode;
    }
    /**
     * Set NetworkCode value
     * @param mixed $networkCode
     * @return \StructType\TrainIdentificationType
     */
    public function setNetworkCode($networkCode = null)
    {
        $this->NetworkCode = $networkCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrainIdentificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
