<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourCodeInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to provide a promotion code and the associated vendor. | Provides the tour code.
 * @subpackage Structs
 */
class TourCodeInfo extends AbstractStructBase
{
    /**
     * The TourTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Type of tour (e.g., IT=inclusive Tour, BT= Bulk Tour, NR=Net Remit).
     * - use: optional
     * @var string
     */
    public $TourTypeCode;
    /**
     * The YearNum
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 9
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $YearNum;
    /**
     * The PartyID
     * Meta information extracted from the WSDL
     * - documentation: Identifier assigned to a tour group by the airline.
     * - use: optional
     * @var string
     */
    public $PartyID;
    /**
     * Constructor method for TourCodeInfo
     * @uses TourCodeInfo::setTourTypeCode()
     * @uses TourCodeInfo::setYearNum()
     * @uses TourCodeInfo::setPartyID()
     * @param string $tourTypeCode
     * @param int $yearNum
     * @param string $partyID
     */
    public function __construct($tourTypeCode = null, $yearNum = null, $partyID = null)
    {
        $this
            ->setTourTypeCode($tourTypeCode)
            ->setYearNum($yearNum)
            ->setPartyID($partyID);
    }
    /**
     * Get TourTypeCode value
     * @return string|null
     */
    public function getTourTypeCode()
    {
        return $this->TourTypeCode;
    }
    /**
     * Set TourTypeCode value
     * @param string $tourTypeCode
     * @return \StructType\TourCodeInfo
     */
    public function setTourTypeCode($tourTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourTypeCode) && !is_string($tourTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourTypeCode, true), gettype($tourTypeCode)), __LINE__);
        }
        $this->TourTypeCode = $tourTypeCode;
        return $this;
    }
    /**
     * Get YearNum value
     * @return int|null
     */
    public function getYearNum()
    {
        return $this->YearNum;
    }
    /**
     * Set YearNum value
     * @param int $yearNum
     * @return \StructType\TourCodeInfo
     */
    public function setYearNum($yearNum = null)
    {
        // validation for constraint: int
        if (!is_null($yearNum) && !(is_int($yearNum) || ctype_digit($yearNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($yearNum, true), gettype($yearNum)), __LINE__);
        }
        // validation for constraint: maxInclusive(9)
        if (!is_null($yearNum) && $yearNum > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9', var_export($yearNum, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($yearNum) && $yearNum < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($yearNum, true)), __LINE__);
        }
        $this->YearNum = $yearNum;
        return $this;
    }
    /**
     * Get PartyID value
     * @return string|null
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param string $partyID
     * @return \StructType\TourCodeInfo
     */
    public function setPartyID($partyID = null)
    {
        // validation for constraint: string
        if (!is_null($partyID) && !is_string($partyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyID, true), gettype($partyID)), __LINE__);
        }
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TourCodeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
