<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Minimum information about ticketing required to complete the booking transaction.
 * @subpackage Structs
 */
class TicketingInfoType extends AbstractStructBase
{
    /**
     * The TicketAdvisory
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\TicketAdvisory[]
     */
    public $TicketAdvisory;
    /**
     * The TicketingVendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TicketingVendor
     */
    public $TicketingVendor;
    /**
     * The PricingSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingSystem
     */
    public $PricingSystem;
    /**
     * The TotalFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalFare
     */
    public $TotalFare;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The TicketTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: TicketTimeLimit - Indicates the ticketing arrangement, and allows for the requirement that an itinerary must be ticketed by a certain date and time.
     * - use: optional
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The CancelOnExpiryInd
     * Meta information extracted from the WSDL
     * - documentation: When true, unticketed bookings should be cancelled when the TicketTimeLimit has expired.
     * - use: optional
     * @var bool
     */
    public $CancelOnExpiryInd;
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - documentation: TicketType - Indicates the type of ticket (Paper, eTicket).
     * - use: optional
     * @var string
     */
    public $TicketType;
    /**
     * The TicketingStatus
     * Meta information extracted from the WSDL
     * - documentation: Code for setting and displaying detailed ticketing information. Refer to OpenTravel Code List Ticketing Status (TST).
     * - use: optional
     * @var string
     */
    public $TicketingStatus;
    /**
     * The FlightSegmentRefNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies one or more segment numbers for ticketing purposes. This RPH is associated with the RPH contained in the FlightSegment element in AirBookRQ.
     * - use: optional
     * @var list
     */
    public $FlightSegmentRefNumber;
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies one or more traveler names for ticketing purposes. This RPH is associated with the RPH contained in the TravelerRefNumber element in AirBookRQ.
     * - use: optional
     * @var list
     */
    public $TravelerRefNumber;
    /**
     * The ReverseTktgSegmentsInd
     * Meta information extracted from the WSDL
     * - documentation: Applies a reverse sequence of the outbound travel to the inbound travel.
     * - use: optional
     * @var bool
     */
    public $ReverseTktgSegmentsInd;
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system.
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The RequestedTicketingDate
     * Meta information extracted from the WSDL
     * - documentation: The date on which ticketing should occur.
     * - use: optional
     * @var string
     */
    public $RequestedTicketingDate;
    /**
     * The TimeLimitMinutes
     * Meta information extracted from the WSDL
     * - documentation: The number of minutes until the ticket must be issued for the itinerary.
     * - use: optional
     * @var int
     */
    public $TimeLimitMinutes;
    /**
     * The BookingChangeType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BookingChangeType;
    /**
     * The TicketDocumentNbr
     * Meta information extracted from the WSDL
     * - documentation: The ticket document number including the airline code, the form code, and the serial number.
     * - use: optional
     * @var string
     */
    public $TicketDocumentNbr;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code used to indicate the ticketing-relevant type of traveler that has been quoted (e.g., MIL, CHD, INF, SEN).
     * - use: optional
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The MiscTicketingCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies one or more ticketing relevant codes. Refer to OpenTravel code list Misc Ticketing Code (MTC).
     * - use: optional
     * @var list
     */
    public $MiscTicketingCode;
    /**
     * Constructor method for TicketingInfoType
     * @uses TicketingInfoType::setTicketAdvisory()
     * @uses TicketingInfoType::setTicketingVendor()
     * @uses TicketingInfoType::setPricingSystem()
     * @uses TicketingInfoType::setTotalFare()
     * @uses TicketingInfoType::setTPA_Extensions()
     * @uses TicketingInfoType::setTicketTimeLimit()
     * @uses TicketingInfoType::setCancelOnExpiryInd()
     * @uses TicketingInfoType::setTicketType()
     * @uses TicketingInfoType::setTicketingStatus()
     * @uses TicketingInfoType::setFlightSegmentRefNumber()
     * @uses TicketingInfoType::setTravelerRefNumber()
     * @uses TicketingInfoType::setReverseTktgSegmentsInd()
     * @uses TicketingInfoType::setPseudoCityCode()
     * @uses TicketingInfoType::setRequestedTicketingDate()
     * @uses TicketingInfoType::setTimeLimitMinutes()
     * @uses TicketingInfoType::setBookingChangeType()
     * @uses TicketingInfoType::setTicketDocumentNbr()
     * @uses TicketingInfoType::setPassengerTypeCode()
     * @uses TicketingInfoType::setOperation()
     * @uses TicketingInfoType::setMiscTicketingCode()
     * @param \StructType\TicketAdvisory[] $ticketAdvisory
     * @param \StructType\TicketingVendor $ticketingVendor
     * @param \StructType\PricingSystem $pricingSystem
     * @param \StructType\TotalFare $totalFare
     * @param mixed $tPA_Extensions
     * @param string $ticketTimeLimit
     * @param bool $cancelOnExpiryInd
     * @param string $ticketType
     * @param string $ticketingStatus
     * @param list $flightSegmentRefNumber
     * @param list $travelerRefNumber
     * @param bool $reverseTktgSegmentsInd
     * @param string $pseudoCityCode
     * @param string $requestedTicketingDate
     * @param int $timeLimitMinutes
     * @param string $bookingChangeType
     * @param string $ticketDocumentNbr
     * @param string $passengerTypeCode
     * @param string $operation
     * @param list $miscTicketingCode
     */
    public function __construct(array $ticketAdvisory = array(), \StructType\TicketingVendor $ticketingVendor = null, \StructType\PricingSystem $pricingSystem = null, \StructType\TotalFare $totalFare = null, $tPA_Extensions = null, $ticketTimeLimit = null, $cancelOnExpiryInd = null, $ticketType = null, $ticketingStatus = null, list $flightSegmentRefNumber = null, list $travelerRefNumber = null, $reverseTktgSegmentsInd = null, $pseudoCityCode = null, $requestedTicketingDate = null, $timeLimitMinutes = null, $bookingChangeType = null, $ticketDocumentNbr = null, $passengerTypeCode = null, $operation = null, list $miscTicketingCode = null)
    {
        $this
            ->setTicketAdvisory($ticketAdvisory)
            ->setTicketingVendor($ticketingVendor)
            ->setPricingSystem($pricingSystem)
            ->setTotalFare($totalFare)
            ->setTPA_Extensions($tPA_Extensions)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setCancelOnExpiryInd($cancelOnExpiryInd)
            ->setTicketType($ticketType)
            ->setTicketingStatus($ticketingStatus)
            ->setFlightSegmentRefNumber($flightSegmentRefNumber)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setReverseTktgSegmentsInd($reverseTktgSegmentsInd)
            ->setPseudoCityCode($pseudoCityCode)
            ->setRequestedTicketingDate($requestedTicketingDate)
            ->setTimeLimitMinutes($timeLimitMinutes)
            ->setBookingChangeType($bookingChangeType)
            ->setTicketDocumentNbr($ticketDocumentNbr)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setOperation($operation)
            ->setMiscTicketingCode($miscTicketingCode);
    }
    /**
     * Get TicketAdvisory value
     * @return \StructType\TicketAdvisory[]|null
     */
    public function getTicketAdvisory()
    {
        return $this->TicketAdvisory;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketAdvisory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketAdvisory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketAdvisoryForArrayConstraintsFromSetTicketAdvisory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketingInfoTypeTicketAdvisoryItem) {
            // validation for constraint: itemType
            if (!$ticketingInfoTypeTicketAdvisoryItem instanceof \StructType\TicketAdvisory) {
                $invalidValues[] = is_object($ticketingInfoTypeTicketAdvisoryItem) ? get_class($ticketingInfoTypeTicketAdvisoryItem) : sprintf('%s(%s)', gettype($ticketingInfoTypeTicketAdvisoryItem), var_export($ticketingInfoTypeTicketAdvisoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketAdvisory property can only contain items of type \StructType\TicketAdvisory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketAdvisory[] $ticketAdvisory
     * @return \StructType\TicketingInfoType
     */
    public function setTicketAdvisory(array $ticketAdvisory = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketAdvisoryArrayErrorMessage = self::validateTicketAdvisoryForArrayConstraintsFromSetTicketAdvisory($ticketAdvisory))) {
            throw new \InvalidArgumentException($ticketAdvisoryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($ticketAdvisory) && count($ticketAdvisory) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($ticketAdvisory)), __LINE__);
        }
        $this->TicketAdvisory = $ticketAdvisory;
        return $this;
    }
    /**
     * Add item to TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketAdvisory $item
     * @return \StructType\TicketingInfoType
     */
    public function addToTicketAdvisory(\StructType\TicketAdvisory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketAdvisory) {
            throw new \InvalidArgumentException(sprintf('The TicketAdvisory property can only contain items of type \StructType\TicketAdvisory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->TicketAdvisory) && count($this->TicketAdvisory) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->TicketAdvisory)), __LINE__);
        }
        $this->TicketAdvisory[] = $item;
        return $this;
    }
    /**
     * Get TicketingVendor value
     * @return \StructType\TicketingVendor|null
     */
    public function getTicketingVendor()
    {
        return $this->TicketingVendor;
    }
    /**
     * Set TicketingVendor value
     * @param \StructType\TicketingVendor $ticketingVendor
     * @return \StructType\TicketingInfoType
     */
    public function setTicketingVendor(\StructType\TicketingVendor $ticketingVendor = null)
    {
        $this->TicketingVendor = $ticketingVendor;
        return $this;
    }
    /**
     * Get PricingSystem value
     * @return \StructType\PricingSystem|null
     */
    public function getPricingSystem()
    {
        return $this->PricingSystem;
    }
    /**
     * Set PricingSystem value
     * @param \StructType\PricingSystem $pricingSystem
     * @return \StructType\TicketingInfoType
     */
    public function setPricingSystem(\StructType\PricingSystem $pricingSystem = null)
    {
        $this->PricingSystem = $pricingSystem;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \StructType\TotalFare|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \StructType\TotalFare $totalFare
     * @return \StructType\TicketingInfoType
     */
    public function setTotalFare(\StructType\TotalFare $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\TicketingInfoType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \StructType\TicketingInfoType
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($ticketTimeLimit) && !is_string($ticketTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketTimeLimit, true), gettype($ticketTimeLimit)), __LINE__);
        }
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get CancelOnExpiryInd value
     * @return bool|null
     */
    public function getCancelOnExpiryInd()
    {
        return $this->CancelOnExpiryInd;
    }
    /**
     * Set CancelOnExpiryInd value
     * @param bool $cancelOnExpiryInd
     * @return \StructType\TicketingInfoType
     */
    public function setCancelOnExpiryInd($cancelOnExpiryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelOnExpiryInd) && !is_bool($cancelOnExpiryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelOnExpiryInd, true), gettype($cancelOnExpiryInd)), __LINE__);
        }
        $this->CancelOnExpiryInd = $cancelOnExpiryInd;
        return $this;
    }
    /**
     * Get TicketType value
     * @return string|null
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @uses \EnumType\TicketType::valueIsValid()
     * @uses \EnumType\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \StructType\TicketingInfoType
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TicketType::valueIsValid($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TicketType', is_array($ticketType) ? implode(', ', $ticketType) : var_export($ticketType, true), implode(', ', \EnumType\TicketType::getValidValues())), __LINE__);
        }
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get TicketingStatus value
     * @return string|null
     */
    public function getTicketingStatus()
    {
        return $this->TicketingStatus;
    }
    /**
     * Set TicketingStatus value
     * @param string $ticketingStatus
     * @return \StructType\TicketingInfoType
     */
    public function setTicketingStatus($ticketingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingStatus) && !is_string($ticketingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingStatus, true), gettype($ticketingStatus)), __LINE__);
        }
        $this->TicketingStatus = $ticketingStatus;
        return $this;
    }
    /**
     * Get FlightSegmentRefNumber value
     * @return list|null
     */
    public function getFlightSegmentRefNumber()
    {
        return $this->FlightSegmentRefNumber;
    }
    /**
     * Set FlightSegmentRefNumber value
     * @param list $flightSegmentRefNumber
     * @return \StructType\TicketingInfoType
     */
    public function setFlightSegmentRefNumber(list $flightSegmentRefNumber = null)
    {
        $this->FlightSegmentRefNumber = $flightSegmentRefNumber;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return list|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @param list $travelerRefNumber
     * @return \StructType\TicketingInfoType
     */
    public function setTravelerRefNumber(list $travelerRefNumber = null)
    {
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Get ReverseTktgSegmentsInd value
     * @return bool|null
     */
    public function getReverseTktgSegmentsInd()
    {
        return $this->ReverseTktgSegmentsInd;
    }
    /**
     * Set ReverseTktgSegmentsInd value
     * @param bool $reverseTktgSegmentsInd
     * @return \StructType\TicketingInfoType
     */
    public function setReverseTktgSegmentsInd($reverseTktgSegmentsInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseTktgSegmentsInd) && !is_bool($reverseTktgSegmentsInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reverseTktgSegmentsInd, true), gettype($reverseTktgSegmentsInd)), __LINE__);
        }
        $this->ReverseTktgSegmentsInd = $reverseTktgSegmentsInd;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \StructType\TicketingInfoType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pseudoCityCode, true), gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get RequestedTicketingDate value
     * @return string|null
     */
    public function getRequestedTicketingDate()
    {
        return $this->RequestedTicketingDate;
    }
    /**
     * Set RequestedTicketingDate value
     * @param string $requestedTicketingDate
     * @return \StructType\TicketingInfoType
     */
    public function setRequestedTicketingDate($requestedTicketingDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedTicketingDate) && !is_string($requestedTicketingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedTicketingDate, true), gettype($requestedTicketingDate)), __LINE__);
        }
        $this->RequestedTicketingDate = $requestedTicketingDate;
        return $this;
    }
    /**
     * Get TimeLimitMinutes value
     * @return int|null
     */
    public function getTimeLimitMinutes()
    {
        return $this->TimeLimitMinutes;
    }
    /**
     * Set TimeLimitMinutes value
     * @param int $timeLimitMinutes
     * @return \StructType\TicketingInfoType
     */
    public function setTimeLimitMinutes($timeLimitMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($timeLimitMinutes) && !(is_int($timeLimitMinutes) || ctype_digit($timeLimitMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeLimitMinutes, true), gettype($timeLimitMinutes)), __LINE__);
        }
        $this->TimeLimitMinutes = $timeLimitMinutes;
        return $this;
    }
    /**
     * Get BookingChangeType value
     * @return string|null
     */
    public function getBookingChangeType()
    {
        return $this->BookingChangeType;
    }
    /**
     * Set BookingChangeType value
     * @param string $bookingChangeType
     * @return \StructType\TicketingInfoType
     */
    public function setBookingChangeType($bookingChangeType = null)
    {
        // validation for constraint: string
        if (!is_null($bookingChangeType) && !is_string($bookingChangeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingChangeType, true), gettype($bookingChangeType)), __LINE__);
        }
        $this->BookingChangeType = $bookingChangeType;
        return $this;
    }
    /**
     * Get TicketDocumentNbr value
     * @return string|null
     */
    public function getTicketDocumentNbr()
    {
        return $this->TicketDocumentNbr;
    }
    /**
     * Set TicketDocumentNbr value
     * @param string $ticketDocumentNbr
     * @return \StructType\TicketingInfoType
     */
    public function setTicketDocumentNbr($ticketDocumentNbr = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocumentNbr) && !is_string($ticketDocumentNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocumentNbr, true), gettype($ticketDocumentNbr)), __LINE__);
        }
        $this->TicketDocumentNbr = $ticketDocumentNbr;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \StructType\TicketingInfoType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\TicketingInfoType
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get MiscTicketingCode value
     * @return list|null
     */
    public function getMiscTicketingCode()
    {
        return $this->MiscTicketingCode;
    }
    /**
     * Set MiscTicketingCode value
     * @param list $miscTicketingCode
     * @return \StructType\TicketingInfoType
     */
    public function setMiscTicketingCode(list $miscTicketingCode = null)
    {
        $this->MiscTicketingCode = $miscTicketingCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
