<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for ticketing information.
 * @subpackage Structs
 */
class TicketingInfo extends TicketingInfoRS_Type
{
    /**
     * The DeliveryInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\DeliveryInfo[]
     */
    public $DeliveryInfo;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - documentation: Specifies the allowable forms of payment (i.e., check, cash, credit card). Refer to OpenTravel Code List Payment Type (PMT).
     * - use: optional
     * @var list
     */
    public $PaymentType;
    /**
     * Constructor method for TicketingInfo
     * @uses TicketingInfo::setDeliveryInfo()
     * @uses TicketingInfo::setPaymentType()
     * @param \StructType\DeliveryInfo[] $deliveryInfo
     * @param list $paymentType
     */
    public function __construct(array $deliveryInfo = array(), list $paymentType = null)
    {
        $this
            ->setDeliveryInfo($deliveryInfo)
            ->setPaymentType($paymentType);
    }
    /**
     * Get DeliveryInfo value
     * @return \StructType\DeliveryInfo[]|null
     */
    public function getDeliveryInfo()
    {
        return $this->DeliveryInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryInfoForArrayConstraintsFromSetDeliveryInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketingInfoDeliveryInfoItem) {
            // validation for constraint: itemType
            if (!$ticketingInfoDeliveryInfoItem instanceof \StructType\DeliveryInfo) {
                $invalidValues[] = is_object($ticketingInfoDeliveryInfoItem) ? get_class($ticketingInfoDeliveryInfoItem) : sprintf('%s(%s)', gettype($ticketingInfoDeliveryInfoItem), var_export($ticketingInfoDeliveryInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryInfo property can only contain items of type \StructType\DeliveryInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveryInfo[] $deliveryInfo
     * @return \StructType\TicketingInfo
     */
    public function setDeliveryInfo(array $deliveryInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryInfoArrayErrorMessage = self::validateDeliveryInfoForArrayConstraintsFromSetDeliveryInfo($deliveryInfo))) {
            throw new \InvalidArgumentException($deliveryInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($deliveryInfo) && count($deliveryInfo) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($deliveryInfo)), __LINE__);
        }
        $this->DeliveryInfo = $deliveryInfo;
        return $this;
    }
    /**
     * Add item to DeliveryInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveryInfo $item
     * @return \StructType\TicketingInfo
     */
    public function addToDeliveryInfo(\StructType\DeliveryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeliveryInfo) {
            throw new \InvalidArgumentException(sprintf('The DeliveryInfo property can only contain items of type \StructType\DeliveryInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->DeliveryInfo) && count($this->DeliveryInfo) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->DeliveryInfo)), __LINE__);
        }
        $this->DeliveryInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return list|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param list $paymentType
     * @return \StructType\TicketingInfo
     */
    public function setPaymentType(list $paymentType = null)
    {
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TicketingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
