<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of a ticket to be exchanged.
 * @subpackage Structs
 */
class Ticket extends AbstractStructBase
{
    /**
     * The ConjunctionTicketNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \StructType\ConjunctionTicketNbr[]
     */
    public $ConjunctionTicketNbr;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: The ticket number which is exchanged.
     * @var string
     */
    public $TicketNumber;
    /**
     * The ReroutingType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReroutingType;
    /**
     * The ReasonForReroute
     * Meta information extracted from the WSDL
     * - documentation: Gives more information about the rerouting.
     * - use: optional
     * @var string
     */
    public $ReasonForReroute;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setConjunctionTicketNbr()
     * @uses Ticket::setTicketNumber()
     * @uses Ticket::setReroutingType()
     * @uses Ticket::setReasonForReroute()
     * @param \StructType\ConjunctionTicketNbr[] $conjunctionTicketNbr
     * @param string $ticketNumber
     * @param string $reroutingType
     * @param string $reasonForReroute
     */
    public function __construct(array $conjunctionTicketNbr = array(), $ticketNumber = null, $reroutingType = null, $reasonForReroute = null)
    {
        $this
            ->setConjunctionTicketNbr($conjunctionTicketNbr)
            ->setTicketNumber($ticketNumber)
            ->setReroutingType($reroutingType)
            ->setReasonForReroute($reasonForReroute);
    }
    /**
     * Get ConjunctionTicketNbr value
     * @return \StructType\ConjunctionTicketNbr[]|null
     */
    public function getConjunctionTicketNbr()
    {
        return $this->ConjunctionTicketNbr;
    }
    /**
     * This method is responsible for validating the values passed to the setConjunctionTicketNbr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConjunctionTicketNbr method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConjunctionTicketNbrForArrayConstraintsFromSetConjunctionTicketNbr(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketConjunctionTicketNbrItem) {
            // validation for constraint: itemType
            if (!$ticketConjunctionTicketNbrItem instanceof \StructType\ConjunctionTicketNbr) {
                $invalidValues[] = is_object($ticketConjunctionTicketNbrItem) ? get_class($ticketConjunctionTicketNbrItem) : sprintf('%s(%s)', gettype($ticketConjunctionTicketNbrItem), var_export($ticketConjunctionTicketNbrItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConjunctionTicketNbr property can only contain items of type \StructType\ConjunctionTicketNbr, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConjunctionTicketNbr value
     * @throws \InvalidArgumentException
     * @param \StructType\ConjunctionTicketNbr[] $conjunctionTicketNbr
     * @return \StructType\Ticket
     */
    public function setConjunctionTicketNbr(array $conjunctionTicketNbr = array())
    {
        // validation for constraint: array
        if ('' !== ($conjunctionTicketNbrArrayErrorMessage = self::validateConjunctionTicketNbrForArrayConstraintsFromSetConjunctionTicketNbr($conjunctionTicketNbr))) {
            throw new \InvalidArgumentException($conjunctionTicketNbrArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($conjunctionTicketNbr) && count($conjunctionTicketNbr) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 16', count($conjunctionTicketNbr)), __LINE__);
        }
        $this->ConjunctionTicketNbr = $conjunctionTicketNbr;
        return $this;
    }
    /**
     * Add item to ConjunctionTicketNbr value
     * @throws \InvalidArgumentException
     * @param \StructType\ConjunctionTicketNbr $item
     * @return \StructType\Ticket
     */
    public function addToConjunctionTicketNbr(\StructType\ConjunctionTicketNbr $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConjunctionTicketNbr) {
            throw new \InvalidArgumentException(sprintf('The ConjunctionTicketNbr property can only contain items of type \StructType\ConjunctionTicketNbr, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($this->ConjunctionTicketNbr) && count($this->ConjunctionTicketNbr) >= 16) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 16', count($this->ConjunctionTicketNbr)), __LINE__);
        }
        $this->ConjunctionTicketNbr[] = $item;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\Ticket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get ReroutingType value
     * @return string|null
     */
    public function getReroutingType()
    {
        return $this->ReroutingType;
    }
    /**
     * Set ReroutingType value
     * @param string $reroutingType
     * @return \StructType\Ticket
     */
    public function setReroutingType($reroutingType = null)
    {
        // validation for constraint: string
        if (!is_null($reroutingType) && !is_string($reroutingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reroutingType, true), gettype($reroutingType)), __LINE__);
        }
        $this->ReroutingType = $reroutingType;
        return $this;
    }
    /**
     * Get ReasonForReroute value
     * @return string|null
     */
    public function getReasonForReroute()
    {
        return $this->ReasonForReroute;
    }
    /**
     * Set ReasonForReroute value
     * @param string $reasonForReroute
     * @return \StructType\Ticket
     */
    public function setReasonForReroute($reasonForReroute = null)
    {
        // validation for constraint: string
        if (!is_null($reasonForReroute) && !is_string($reasonForReroute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonForReroute, true), gettype($reasonForReroute)), __LINE__);
        }
        $this->ReasonForReroute = $reasonForReroute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ticket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
