<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taxes StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of taxes. | This is a collection of Taxes | The tax, fee, or charge amount information. | A collection of taxes applicable to the carrier fee. | The effective date range for the tax information. | Information on
 * additional taxes that may apply to the rental. | Fee taxes.
 * @subpackage Structs
 */
class Taxes extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The total amount for all ticket fee taxes. | The total of all the taxes.
     * - minOccurs: 0
     * - use: optional
     * @var \StructType\Amount
     */
    public $Amount;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Tax type.
     * - minOccurs: 0
     * @var mixed
     */
    public $Type;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Implementer: The associated language identifier for this descriptive information is specified in the @Language attribute. | Tax description.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var string[]
     */
    public $Description;
    /**
     * The Qualifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Qualifiers
     */
    public $Qualifiers;
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the tax is mandatory. | Example: true | Mandatory tax indicator.
     * - use: optional
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The TaxRPH
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $TaxRPH;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: The tax for the ticket fee. | Any individual tax applied to the fare | A tax applicable to a carrier fee or to the carrier fee tax.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Tax[]
     */
    public $Tax;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - documentation: General information about the additional taxes that may apply.
     * - minOccurs: 0
     * @var mixed
     */
    public $Info;
    /**
     * Constructor method for Taxes
     * @uses Taxes::setAmount()
     * @uses Taxes::setType()
     * @uses Taxes::setDescription()
     * @uses Taxes::setQualifiers()
     * @uses Taxes::setMandatoryInd()
     * @uses Taxes::setTaxRPH()
     * @uses Taxes::setTax()
     * @uses Taxes::setInfo()
     * @param \StructType\Amount $amount
     * @param mixed $type
     * @param string[] $description
     * @param \StructType\Qualifiers $qualifiers
     * @param bool $mandatoryInd
     * @param string $taxRPH
     * @param \StructType\Tax[] $tax
     * @param mixed $info
     */
    public function __construct(\StructType\Amount $amount = null, $type = null, array $description = array(), \StructType\Qualifiers $qualifiers = null, $mandatoryInd = null, $taxRPH = null, array $tax = array(), $info = null)
    {
        $this
            ->setAmount($amount)
            ->setType($type)
            ->setDescription($description)
            ->setQualifiers($qualifiers)
            ->setMandatoryInd($mandatoryInd)
            ->setTaxRPH($taxRPH)
            ->setTax($tax)
            ->setInfo($info);
    }
    /**
     * Get Amount value
     * @return \StructType\Amount|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\Amount $amount
     * @return \StructType\Taxes
     */
    public function setAmount(\StructType\Amount $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Type value
     * @return mixed|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param mixed $type
     * @return \StructType\Taxes
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxesDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($taxesDescriptionItem)) {
                $invalidValues[] = is_object($taxesDescriptionItem) ? get_class($taxesDescriptionItem) : sprintf('%s(%s)', gettype($taxesDescriptionItem), var_export($taxesDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \StructType\Taxes
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($description) && count($description) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Taxes
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Description) && count($this->Description) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Qualifiers value
     * @return \StructType\Qualifiers|null
     */
    public function getQualifiers()
    {
        return $this->Qualifiers;
    }
    /**
     * Set Qualifiers value
     * @param \StructType\Qualifiers $qualifiers
     * @return \StructType\Taxes
     */
    public function setQualifiers(\StructType\Qualifiers $qualifiers = null)
    {
        $this->Qualifiers = $qualifiers;
        return $this;
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\Taxes
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get TaxRPH value
     * @return string|null
     */
    public function getTaxRPH()
    {
        return $this->TaxRPH;
    }
    /**
     * Set TaxRPH value
     * @param string $taxRPH
     * @return \StructType\Taxes
     */
    public function setTaxRPH($taxRPH = null)
    {
        // validation for constraint: string
        if (!is_null($taxRPH) && !is_string($taxRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxRPH, true), gettype($taxRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($taxRPH) && !preg_match('/[0-9]{1,8}/', $taxRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($taxRPH, true)), __LINE__);
        }
        $this->TaxRPH = $taxRPH;
        return $this;
    }
    /**
     * Get Tax value
     * @return \StructType\Tax[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxesTaxItem) {
            // validation for constraint: itemType
            if (!$taxesTaxItem instanceof \StructType\Tax) {
                $invalidValues[] = is_object($taxesTaxItem) ? get_class($taxesTaxItem) : sprintf('%s(%s)', gettype($taxesTaxItem), var_export($taxesTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \StructType\Tax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax[] $tax
     * @return \StructType\Taxes
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($tax) && count($tax) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax $item
     * @return \StructType\Taxes
     */
    public function addToTax(\StructType\Tax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \StructType\Tax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Tax) && count($this->Tax) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Tax)), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get Info value
     * @return mixed|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param mixed $info
     * @return \StructType\Taxes
     */
    public function setInfo($info = null)
    {
        $this->Info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Taxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
