<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies charge information by unit (e.g., room, person, item) and frequency (e.g., daily, weekly, stay). | Provides the effective and expiry dates for the tax. | Provides details of the tax. | Applicable tax element. This element
 * allows for both percentages and flat amounts. If one field is used, the other should be zero since logically, taxes should be calculated in only one of the two ways.
 * @subpackage Structs
 */
class TaxType extends AbstractStructBase
{
    /**
     * The TaxDescription
     * Meta information extracted from the WSDL
     * - documentation: Text description of the taxes in a given language.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TaxDescription;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The SequenceNbr
     * Meta information extracted from the WSDL
     * - documentation: A number assigned by the responding system to designate the order of this tax among multiple taxes.
     * - use: optional
     * @var int
     */
    public $SequenceNbr;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: The duration datatype represents a combination of year, month, day and time values representing a single duration of time, encoded as a single string.
     * - use: optional
     * @var string
     */
    public $Duration;
    /**
     * Constructor method for TaxType
     * @uses TaxType::setTaxDescription()
     * @uses TaxType::setTPA_Extensions()
     * @uses TaxType::setSequenceNbr()
     * @uses TaxType::setDuration()
     * @param mixed[] $taxDescription
     * @param mixed $tPA_Extensions
     * @param int $sequenceNbr
     * @param string $duration
     */
    public function __construct(array $taxDescription = array(), $tPA_Extensions = null, $sequenceNbr = null, $duration = null)
    {
        $this
            ->setTaxDescription($taxDescription)
            ->setTPA_Extensions($tPA_Extensions)
            ->setSequenceNbr($sequenceNbr)
            ->setDuration($duration);
    }
    /**
     * Get TaxDescription value
     * @return mixed[]|null
     */
    public function getTaxDescription()
    {
        return $this->TaxDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxDescriptionForArrayConstraintsFromSetTaxDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxTypeTaxDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($taxTypeTaxDescriptionItem) ? get_class($taxTypeTaxDescriptionItem) : sprintf('%s(%s)', gettype($taxTypeTaxDescriptionItem), var_export($taxTypeTaxDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $taxDescription
     * @return \StructType\TaxType
     */
    public function setTaxDescription(array $taxDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($taxDescriptionArrayErrorMessage = self::validateTaxDescriptionForArrayConstraintsFromSetTaxDescription($taxDescription))) {
            throw new \InvalidArgumentException($taxDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($taxDescription) && count($taxDescription) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($taxDescription)), __LINE__);
        }
        $this->TaxDescription = $taxDescription;
        return $this;
    }
    /**
     * Add item to TaxDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\TaxType
     */
    public function addToTaxDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TaxDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->TaxDescription) && count($this->TaxDescription) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->TaxDescription)), __LINE__);
        }
        $this->TaxDescription[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\TaxType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get SequenceNbr value
     * @return int|null
     */
    public function getSequenceNbr()
    {
        return $this->SequenceNbr;
    }
    /**
     * Set SequenceNbr value
     * @param int $sequenceNbr
     * @return \StructType\TaxType
     */
    public function setSequenceNbr($sequenceNbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNbr) && !(is_int($sequenceNbr) || ctype_digit($sequenceNbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNbr, true), gettype($sequenceNbr)), __LINE__);
        }
        $this->SequenceNbr = $sequenceNbr;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\TaxType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
