<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxPolicies StructType
 * Meta information extracted from the WSDL
 * - documentation: Property tax policies.
 * @subpackage Structs
 */
class TaxPolicies extends AbstractStructBase
{
    /**
     * The TaxPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxPolicy[]
     */
    public $TaxPolicy;
    /**
     * Constructor method for TaxPolicies
     * @uses TaxPolicies::setTaxPolicy()
     * @param \StructType\TaxPolicy[] $taxPolicy
     */
    public function __construct(array $taxPolicy = array())
    {
        $this
            ->setTaxPolicy($taxPolicy);
    }
    /**
     * Get TaxPolicy value
     * @return \StructType\TaxPolicy[]|null
     */
    public function getTaxPolicy()
    {
        return $this->TaxPolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxPolicyForArrayConstraintsFromSetTaxPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxPoliciesTaxPolicyItem) {
            // validation for constraint: itemType
            if (!$taxPoliciesTaxPolicyItem instanceof \StructType\TaxPolicy) {
                $invalidValues[] = is_object($taxPoliciesTaxPolicyItem) ? get_class($taxPoliciesTaxPolicyItem) : sprintf('%s(%s)', gettype($taxPoliciesTaxPolicyItem), var_export($taxPoliciesTaxPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxPolicy property can only contain items of type \StructType\TaxPolicy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxPolicy[] $taxPolicy
     * @return \StructType\TaxPolicies
     */
    public function setTaxPolicy(array $taxPolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($taxPolicyArrayErrorMessage = self::validateTaxPolicyForArrayConstraintsFromSetTaxPolicy($taxPolicy))) {
            throw new \InvalidArgumentException($taxPolicyArrayErrorMessage, __LINE__);
        }
        $this->TaxPolicy = $taxPolicy;
        return $this;
    }
    /**
     * Add item to TaxPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxPolicy $item
     * @return \StructType\TaxPolicies
     */
    public function addToTaxPolicy(\StructType\TaxPolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxPolicy) {
            throw new \InvalidArgumentException(sprintf('The TaxPolicy property can only contain items of type \StructType\TaxPolicy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxPolicy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxPolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
