<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines a tax item on an invoice
 * @subpackage Structs
 */
class TaxItemType extends AbstractStructBase
{
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TaxAmount[]
     */
    public $TaxAmount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A short description of the tax item.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - documentation: A percentage rate of tax.
     * - use: optional
     * @var float
     */
    public $Rate;
    /**
     * Constructor method for TaxItemType
     * @uses TaxItemType::setTaxAmount()
     * @uses TaxItemType::setDescription()
     * @uses TaxItemType::setCode()
     * @uses TaxItemType::setRate()
     * @param \StructType\TaxAmount[] $taxAmount
     * @param string $description
     * @param string $code
     * @param float $rate
     */
    public function __construct(array $taxAmount = array(), $description = null, $code = null, $rate = null)
    {
        $this
            ->setTaxAmount($taxAmount)
            ->setDescription($description)
            ->setCode($code)
            ->setRate($rate);
    }
    /**
     * Get TaxAmount value
     * @return \StructType\TaxAmount[]|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxAmountForArrayConstraintsFromSetTaxAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxItemTypeTaxAmountItem) {
            // validation for constraint: itemType
            if (!$taxItemTypeTaxAmountItem instanceof \StructType\TaxAmount) {
                $invalidValues[] = is_object($taxItemTypeTaxAmountItem) ? get_class($taxItemTypeTaxAmountItem) : sprintf('%s(%s)', gettype($taxItemTypeTaxAmountItem), var_export($taxItemTypeTaxAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxAmount property can only contain items of type \StructType\TaxAmount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxAmount[] $taxAmount
     * @return \StructType\TaxItemType
     */
    public function setTaxAmount(array $taxAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($taxAmountArrayErrorMessage = self::validateTaxAmountForArrayConstraintsFromSetTaxAmount($taxAmount))) {
            throw new \InvalidArgumentException($taxAmountArrayErrorMessage, __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Add item to TaxAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxAmount $item
     * @return \StructType\TaxItemType
     */
    public function addToTaxAmount(\StructType\TaxAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxAmount) {
            throw new \InvalidArgumentException(sprintf('The TaxAmount property can only contain items of type \StructType\TaxAmount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxAmount[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\TaxItemType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\TaxItemType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\TaxItemType
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
