<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxCouponInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify tax coupon information.
 * @subpackage Structs
 */
class TaxCouponInformation extends AbstractStructBase
{
    /**
     * The TicketDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * @var \StructType\TicketDocument[]
     */
    public $TicketDocument;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: The date of birth of the passenger.
     * - use: optional
     * @var string
     */
    public $BirthDate;
    /**
     * The JourneyTurnaroundCityCode
     * Meta information extracted from the WSDL
     * - documentation: The airport/city code which has been assumed to be the journey turnaround point in the construction of the itinerary by the pricing system.
     * - use: optional
     * @var string
     */
    public $JourneyTurnaroundCityCode;
    /**
     * Constructor method for TaxCouponInformation
     * @uses TaxCouponInformation::setTicketDocument()
     * @uses TaxCouponInformation::setBirthDate()
     * @uses TaxCouponInformation::setJourneyTurnaroundCityCode()
     * @param \StructType\TicketDocument[] $ticketDocument
     * @param string $birthDate
     * @param string $journeyTurnaroundCityCode
     */
    public function __construct(array $ticketDocument = array(), $birthDate = null, $journeyTurnaroundCityCode = null)
    {
        $this
            ->setTicketDocument($ticketDocument)
            ->setBirthDate($birthDate)
            ->setJourneyTurnaroundCityCode($journeyTurnaroundCityCode);
    }
    /**
     * Get TicketDocument value
     * @return \StructType\TicketDocument[]|null
     */
    public function getTicketDocument()
    {
        return $this->TicketDocument;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDocumentForArrayConstraintsFromSetTicketDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxCouponInformationTicketDocumentItem) {
            // validation for constraint: itemType
            if (!$taxCouponInformationTicketDocumentItem instanceof \StructType\TicketDocument) {
                $invalidValues[] = is_object($taxCouponInformationTicketDocumentItem) ? get_class($taxCouponInformationTicketDocumentItem) : sprintf('%s(%s)', gettype($taxCouponInformationTicketDocumentItem), var_export($taxCouponInformationTicketDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDocument property can only contain items of type \StructType\TicketDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocument[] $ticketDocument
     * @return \StructType\TaxCouponInformation
     */
    public function setTicketDocument(array $ticketDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDocumentArrayErrorMessage = self::validateTicketDocumentForArrayConstraintsFromSetTicketDocument($ticketDocument))) {
            throw new \InvalidArgumentException($ticketDocumentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($ticketDocument) && count($ticketDocument) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($ticketDocument)), __LINE__);
        }
        $this->TicketDocument = $ticketDocument;
        return $this;
    }
    /**
     * Add item to TicketDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocument $item
     * @return \StructType\TaxCouponInformation
     */
    public function addToTicketDocument(\StructType\TicketDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketDocument) {
            throw new \InvalidArgumentException(sprintf('The TicketDocument property can only contain items of type \StructType\TicketDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->TicketDocument) && count($this->TicketDocument) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->TicketDocument)), __LINE__);
        }
        $this->TicketDocument[] = $item;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\TaxCouponInformation
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get JourneyTurnaroundCityCode value
     * @return string|null
     */
    public function getJourneyTurnaroundCityCode()
    {
        return $this->JourneyTurnaroundCityCode;
    }
    /**
     * Set JourneyTurnaroundCityCode value
     * @param string $journeyTurnaroundCityCode
     * @return \StructType\TaxCouponInformation
     */
    public function setJourneyTurnaroundCityCode($journeyTurnaroundCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($journeyTurnaroundCityCode) && !is_string($journeyTurnaroundCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journeyTurnaroundCityCode, true), gettype($journeyTurnaroundCityCode)), __LINE__);
        }
        $this->JourneyTurnaroundCityCode = $journeyTurnaroundCityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxCouponInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
