<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxCouponInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: The tax coupon information for cabin and air equipment.
 * @subpackage Structs
 */
class TaxCouponInfo extends AbstractStructBase
{
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - documentation: The sold cabin of passenger travel for the coupon.
     * - use: optional
     * @var string
     */
    public $Cabin;
    /**
     * The AirEquipType
     * Meta information extracted from the WSDL
     * - documentation: The standard code of the equipment used for the coupon flight.
     * - use: optional
     * @var string
     */
    public $AirEquipType;
    /**
     * Constructor method for TaxCouponInfo
     * @uses TaxCouponInfo::setCabin()
     * @uses TaxCouponInfo::setAirEquipType()
     * @param string $cabin
     * @param string $airEquipType
     */
    public function __construct($cabin = null, $airEquipType = null)
    {
        $this
            ->setCabin($cabin)
            ->setAirEquipType($airEquipType);
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabin
     * @return \StructType\TaxCouponInfo
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($cabin) ? implode(', ', $cabin) : var_export($cabin, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get AirEquipType value
     * @return string|null
     */
    public function getAirEquipType()
    {
        return $this->AirEquipType;
    }
    /**
     * Set AirEquipType value
     * @param string $airEquipType
     * @return \StructType\TaxCouponInfo
     */
    public function setAirEquipType($airEquipType = null)
    {
        // validation for constraint: string
        if (!is_null($airEquipType) && !is_string($airEquipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airEquipType, true), gettype($airEquipType)), __LINE__);
        }
        $this->AirEquipType = $airEquipType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxCouponInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
