<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Surcharges StructType
 * Meta information extracted from the WSDL
 * - documentation: The efective date range for the surcharge information. | Information on additional surcharges that may apply to the rental.
 * @subpackage Structs
 */
class Surcharges extends AbstractStructBase
{
    /**
     * The Surcharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Surcharge[]
     */
    public $Surcharge;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - documentation: General information about the additional surcharges that may apply.
     * - minOccurs: 0
     * @var mixed
     */
    public $Info;
    /**
     * Constructor method for Surcharges
     * @uses Surcharges::setSurcharge()
     * @uses Surcharges::setInfo()
     * @param \StructType\Surcharge[] $surcharge
     * @param mixed $info
     */
    public function __construct(array $surcharge = array(), $info = null)
    {
        $this
            ->setSurcharge($surcharge)
            ->setInfo($info);
    }
    /**
     * Get Surcharge value
     * @return \StructType\Surcharge[]|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * This method is responsible for validating the values passed to the setSurcharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurcharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSurchargeForArrayConstraintsFromSetSurcharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surchargesSurchargeItem) {
            // validation for constraint: itemType
            if (!$surchargesSurchargeItem instanceof \StructType\Surcharge) {
                $invalidValues[] = is_object($surchargesSurchargeItem) ? get_class($surchargesSurchargeItem) : sprintf('%s(%s)', gettype($surchargesSurchargeItem), var_export($surchargesSurchargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Surcharge property can only contain items of type \StructType\Surcharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\Surcharge[] $surcharge
     * @return \StructType\Surcharges
     */
    public function setSurcharge(array $surcharge = array())
    {
        // validation for constraint: array
        if ('' !== ($surchargeArrayErrorMessage = self::validateSurchargeForArrayConstraintsFromSetSurcharge($surcharge))) {
            throw new \InvalidArgumentException($surchargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($surcharge) && count($surcharge) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($surcharge)), __LINE__);
        }
        $this->Surcharge = $surcharge;
        return $this;
    }
    /**
     * Add item to Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\Surcharge $item
     * @return \StructType\Surcharges
     */
    public function addToSurcharge(\StructType\Surcharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Surcharge) {
            throw new \InvalidArgumentException(sprintf('The Surcharge property can only contain items of type \StructType\Surcharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Surcharge) && count($this->Surcharge) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Surcharge)), __LINE__);
        }
        $this->Surcharge[] = $item;
        return $this;
    }
    /**
     * Get Info value
     * @return mixed|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param mixed $info
     * @return \StructType\Surcharges
     */
    public function setInfo($info = null)
    {
        $this->Info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Surcharges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
