<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplement StructType
 * Meta information extracted from the WSDL
 * - documentation: The valid dates for the supplement. | Provides the supplement amount (positive or negative) to be applied. | Defines the required ages of the guests in order for this supplement to apply. | Single supplement with conditions of
 * application.
 * @subpackage Structs
 */
class Supplement extends AbstractStructBase
{
    /**
     * The RoomCompanions
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\RoomCompanions[]
     */
    public $RoomCompanions;
    /**
     * The PrerequisiteInventory
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\PrerequisiteInventory[]
     */
    public $PrerequisiteInventory;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description of the supplement.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * The SupplementType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplementType;
    /**
     * The ChargeTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Describes what the charge refers to and with what frequency. Refer to OpenTravel Code Table Charge Type (CHG).
     * - use: optional
     * @var string
     */
    public $ChargeTypeCode;
    /**
     * The InvCode
     * Meta information extracted from the WSDL
     * - documentation: A code defining the inventory item to which this supplement applies.
     * - use: optional
     * @var string
     */
    public $InvCode;
    /**
     * The InvType
     * Meta information extracted from the WSDL
     * - documentation: The inventory type to which the supplement applies.
     * - use: optional
     * @var string
     */
    public $InvType;
    /**
     * The AdditionalGuestNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the guest of this age group beyond the standard occupancy for the room (e.g., Double room with standard occupancy =2; AdditionalGuestNumber = 1 => 3rd adult; AdditionalGuestNumber = 2 => 4th adult ).
     * - use: optional
     * @var int
     */
    public $AdditionalGuestNumber;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: This reference placeholder is commonly used to associate this supplement with the appropriate offer(s).
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: The percentage (postiive or negative) to be applied to the basic rate to calculate the supplement amount.
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The AddToBasicRateIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the value in Amount must be added to the basic rate, otherwise it would replace the basic rate amount.
     * - use: optional
     * @var bool
     */
    public $AddToBasicRateIndicator;
    /**
     * The SingleUseIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that this is a supplement for single use (e.g., indicates that this supplement is the additional amount charged for single use of a double room).
     * - use: optional
     * @var bool
     */
    public $SingleUseIndicator;
    /**
     * The MandatoryIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that this supplement must be applied when applicable (e.g., a surcharge for "Xmas Eve Gala Dinner" which must be applied if the room is booked for December 24th).
     * - use: optional
     * @var bool
     */
    public $MandatoryIndicator;
    /**
     * Constructor method for Supplement
     * @uses Supplement::setRoomCompanions()
     * @uses Supplement::setPrerequisiteInventory()
     * @uses Supplement::setDescription()
     * @uses Supplement::setSupplementType()
     * @uses Supplement::setChargeTypeCode()
     * @uses Supplement::setInvCode()
     * @uses Supplement::setInvType()
     * @uses Supplement::setAdditionalGuestNumber()
     * @uses Supplement::setRPH()
     * @uses Supplement::setPercent()
     * @uses Supplement::setAddToBasicRateIndicator()
     * @uses Supplement::setSingleUseIndicator()
     * @uses Supplement::setMandatoryIndicator()
     * @param \StructType\RoomCompanions[] $roomCompanions
     * @param \StructType\PrerequisiteInventory[] $prerequisiteInventory
     * @param mixed[] $description
     * @param string $supplementType
     * @param string $chargeTypeCode
     * @param string $invCode
     * @param string $invType
     * @param int $additionalGuestNumber
     * @param string $rPH
     * @param float $percent
     * @param bool $addToBasicRateIndicator
     * @param bool $singleUseIndicator
     * @param bool $mandatoryIndicator
     */
    public function __construct(array $roomCompanions = array(), array $prerequisiteInventory = array(), array $description = array(), $supplementType = null, $chargeTypeCode = null, $invCode = null, $invType = null, $additionalGuestNumber = null, $rPH = null, $percent = null, $addToBasicRateIndicator = null, $singleUseIndicator = null, $mandatoryIndicator = null)
    {
        $this
            ->setRoomCompanions($roomCompanions)
            ->setPrerequisiteInventory($prerequisiteInventory)
            ->setDescription($description)
            ->setSupplementType($supplementType)
            ->setChargeTypeCode($chargeTypeCode)
            ->setInvCode($invCode)
            ->setInvType($invType)
            ->setAdditionalGuestNumber($additionalGuestNumber)
            ->setRPH($rPH)
            ->setPercent($percent)
            ->setAddToBasicRateIndicator($addToBasicRateIndicator)
            ->setSingleUseIndicator($singleUseIndicator)
            ->setMandatoryIndicator($mandatoryIndicator);
    }
    /**
     * Get RoomCompanions value
     * @return \StructType\RoomCompanions[]|null
     */
    public function getRoomCompanions()
    {
        return $this->RoomCompanions;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomCompanions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomCompanions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomCompanionsForArrayConstraintsFromSetRoomCompanions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplementRoomCompanionsItem) {
            // validation for constraint: itemType
            if (!$supplementRoomCompanionsItem instanceof \StructType\RoomCompanions) {
                $invalidValues[] = is_object($supplementRoomCompanionsItem) ? get_class($supplementRoomCompanionsItem) : sprintf('%s(%s)', gettype($supplementRoomCompanionsItem), var_export($supplementRoomCompanionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomCompanions property can only contain items of type \StructType\RoomCompanions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomCompanions value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomCompanions[] $roomCompanions
     * @return \StructType\Supplement
     */
    public function setRoomCompanions(array $roomCompanions = array())
    {
        // validation for constraint: array
        if ('' !== ($roomCompanionsArrayErrorMessage = self::validateRoomCompanionsForArrayConstraintsFromSetRoomCompanions($roomCompanions))) {
            throw new \InvalidArgumentException($roomCompanionsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($roomCompanions) && count($roomCompanions) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($roomCompanions)), __LINE__);
        }
        $this->RoomCompanions = $roomCompanions;
        return $this;
    }
    /**
     * Add item to RoomCompanions value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomCompanions $item
     * @return \StructType\Supplement
     */
    public function addToRoomCompanions(\StructType\RoomCompanions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomCompanions) {
            throw new \InvalidArgumentException(sprintf('The RoomCompanions property can only contain items of type \StructType\RoomCompanions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RoomCompanions) && count($this->RoomCompanions) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RoomCompanions)), __LINE__);
        }
        $this->RoomCompanions[] = $item;
        return $this;
    }
    /**
     * Get PrerequisiteInventory value
     * @return \StructType\PrerequisiteInventory[]|null
     */
    public function getPrerequisiteInventory()
    {
        return $this->PrerequisiteInventory;
    }
    /**
     * This method is responsible for validating the values passed to the setPrerequisiteInventory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrerequisiteInventory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrerequisiteInventoryForArrayConstraintsFromSetPrerequisiteInventory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplementPrerequisiteInventoryItem) {
            // validation for constraint: itemType
            if (!$supplementPrerequisiteInventoryItem instanceof \StructType\PrerequisiteInventory) {
                $invalidValues[] = is_object($supplementPrerequisiteInventoryItem) ? get_class($supplementPrerequisiteInventoryItem) : sprintf('%s(%s)', gettype($supplementPrerequisiteInventoryItem), var_export($supplementPrerequisiteInventoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PrerequisiteInventory property can only contain items of type \StructType\PrerequisiteInventory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PrerequisiteInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\PrerequisiteInventory[] $prerequisiteInventory
     * @return \StructType\Supplement
     */
    public function setPrerequisiteInventory(array $prerequisiteInventory = array())
    {
        // validation for constraint: array
        if ('' !== ($prerequisiteInventoryArrayErrorMessage = self::validatePrerequisiteInventoryForArrayConstraintsFromSetPrerequisiteInventory($prerequisiteInventory))) {
            throw new \InvalidArgumentException($prerequisiteInventoryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($prerequisiteInventory) && count($prerequisiteInventory) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($prerequisiteInventory)), __LINE__);
        }
        $this->PrerequisiteInventory = $prerequisiteInventory;
        return $this;
    }
    /**
     * Add item to PrerequisiteInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\PrerequisiteInventory $item
     * @return \StructType\Supplement
     */
    public function addToPrerequisiteInventory(\StructType\PrerequisiteInventory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PrerequisiteInventory) {
            throw new \InvalidArgumentException(sprintf('The PrerequisiteInventory property can only contain items of type \StructType\PrerequisiteInventory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PrerequisiteInventory) && count($this->PrerequisiteInventory) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PrerequisiteInventory)), __LINE__);
        }
        $this->PrerequisiteInventory[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplementDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($supplementDescriptionItem) ? get_class($supplementDescriptionItem) : sprintf('%s(%s)', gettype($supplementDescriptionItem), var_export($supplementDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\Supplement
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($description) && count($description) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Supplement
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Description) && count($this->Description) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get SupplementType value
     * @return string|null
     */
    public function getSupplementType()
    {
        return $this->SupplementType;
    }
    /**
     * Set SupplementType value
     * @param string $supplementType
     * @return \StructType\Supplement
     */
    public function setSupplementType($supplementType = null)
    {
        // validation for constraint: string
        if (!is_null($supplementType) && !is_string($supplementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplementType, true), gettype($supplementType)), __LINE__);
        }
        $this->SupplementType = $supplementType;
        return $this;
    }
    /**
     * Get ChargeTypeCode value
     * @return string|null
     */
    public function getChargeTypeCode()
    {
        return $this->ChargeTypeCode;
    }
    /**
     * Set ChargeTypeCode value
     * @param string $chargeTypeCode
     * @return \StructType\Supplement
     */
    public function setChargeTypeCode($chargeTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeTypeCode) && !is_string($chargeTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeTypeCode, true), gettype($chargeTypeCode)), __LINE__);
        }
        $this->ChargeTypeCode = $chargeTypeCode;
        return $this;
    }
    /**
     * Get InvCode value
     * @return string|null
     */
    public function getInvCode()
    {
        return $this->InvCode;
    }
    /**
     * Set InvCode value
     * @param string $invCode
     * @return \StructType\Supplement
     */
    public function setInvCode($invCode = null)
    {
        // validation for constraint: string
        if (!is_null($invCode) && !is_string($invCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invCode, true), gettype($invCode)), __LINE__);
        }
        $this->InvCode = $invCode;
        return $this;
    }
    /**
     * Get InvType value
     * @return string|null
     */
    public function getInvType()
    {
        return $this->InvType;
    }
    /**
     * Set InvType value
     * @param string $invType
     * @return \StructType\Supplement
     */
    public function setInvType($invType = null)
    {
        // validation for constraint: string
        if (!is_null($invType) && !is_string($invType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invType, true), gettype($invType)), __LINE__);
        }
        $this->InvType = $invType;
        return $this;
    }
    /**
     * Get AdditionalGuestNumber value
     * @return int|null
     */
    public function getAdditionalGuestNumber()
    {
        return $this->AdditionalGuestNumber;
    }
    /**
     * Set AdditionalGuestNumber value
     * @param int $additionalGuestNumber
     * @return \StructType\Supplement
     */
    public function setAdditionalGuestNumber($additionalGuestNumber = null)
    {
        // validation for constraint: int
        if (!is_null($additionalGuestNumber) && !(is_int($additionalGuestNumber) || ctype_digit($additionalGuestNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($additionalGuestNumber, true), gettype($additionalGuestNumber)), __LINE__);
        }
        $this->AdditionalGuestNumber = $additionalGuestNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\Supplement
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\Supplement
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get AddToBasicRateIndicator value
     * @return bool|null
     */
    public function getAddToBasicRateIndicator()
    {
        return $this->AddToBasicRateIndicator;
    }
    /**
     * Set AddToBasicRateIndicator value
     * @param bool $addToBasicRateIndicator
     * @return \StructType\Supplement
     */
    public function setAddToBasicRateIndicator($addToBasicRateIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($addToBasicRateIndicator) && !is_bool($addToBasicRateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addToBasicRateIndicator, true), gettype($addToBasicRateIndicator)), __LINE__);
        }
        $this->AddToBasicRateIndicator = $addToBasicRateIndicator;
        return $this;
    }
    /**
     * Get SingleUseIndicator value
     * @return bool|null
     */
    public function getSingleUseIndicator()
    {
        return $this->SingleUseIndicator;
    }
    /**
     * Set SingleUseIndicator value
     * @param bool $singleUseIndicator
     * @return \StructType\Supplement
     */
    public function setSingleUseIndicator($singleUseIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($singleUseIndicator) && !is_bool($singleUseIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($singleUseIndicator, true), gettype($singleUseIndicator)), __LINE__);
        }
        $this->SingleUseIndicator = $singleUseIndicator;
        return $this;
    }
    /**
     * Get MandatoryIndicator value
     * @return bool|null
     */
    public function getMandatoryIndicator()
    {
        return $this->MandatoryIndicator;
    }
    /**
     * Set MandatoryIndicator value
     * @param bool $mandatoryIndicator
     * @return \StructType\Supplement
     */
    public function setMandatoryIndicator($mandatoryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryIndicator) && !is_bool($mandatoryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryIndicator, true), gettype($mandatoryIndicator)), __LINE__);
        }
        $this->MandatoryIndicator = $mandatoryIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Supplement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
