<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Status StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify the status of the item identified by the ConfID. | Used to specify the status of the reservation with either one of the enumerations in InventoryStatusType or an UpperCaseAlphaLength1to2 code such as an IATA status
 * code. | Provides a search filter by the status of sailing, category, fare, or cabin.
 * - type: OTA_CodeType
 * - union: InventoryStatusType | UpperCaseAlphaLength1to2 | TransactionStatusType | UpperCaseAlphaLength1to2 | TransactionStatusType | UpperCaseAlphaLength1to2
 * - use: optional
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status of the sailing, category, fare, or cabin. Refer to OpenTravel Codelist Status (STS).
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Status
     * @uses Status::setStatus()
     * @param string $status
     */
    public function __construct($status = null)
    {
        $this
            ->setStatus($status);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Status
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Status
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
