<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartAndEnd StructType
 * Meta information extracted from the WSDL
 * - documentation: Start and end date or date and time with duration information.
 * @subpackage Structs
 */
class StartAndEnd extends AbstractStructBase
{
    /**
     * The StartDateTime
     * Meta information extracted from the WSDL
     * - documentation: Example: 2013-01-13T20:32:00 | Start date or date and time.
     * - use: required
     * @var string
     */
    public $StartDateTime;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: Example: 2013-01-13T23:37:00 | End date or date and time.
     * - choice: End | Duration
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $End;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - choice: End | Duration
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Duration
     */
    public $Duration;
    /**
     * Constructor method for StartAndEnd
     * @uses StartAndEnd::setStartDateTime()
     * @uses StartAndEnd::setEnd()
     * @uses StartAndEnd::setDuration()
     * @param string $startDateTime
     * @param string $end
     * @param \StructType\Duration $duration
     */
    public function __construct($startDateTime = null, $end = null, \StructType\Duration $duration = null)
    {
        $this
            ->setStartDateTime($startDateTime)
            ->setEnd($end)
            ->setDuration($duration);
    }
    /**
     * Get StartDateTime value
     * @return string
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \StructType\StartAndEnd
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTime, true), gettype($startDateTime)), __LINE__);
        }
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return isset($this->End) ? $this->End : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEndForChoiceConstraintsFromSetEnd($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Duration',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property End can\'t be set as the property %s is already set. Only one property must be set among these properties: End, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set End value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $end
     * @return \StructType\StartAndEnd
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: choice(End, Duration)
        if ('' !== ($endChoiceErrorMessage = self::validateEndForChoiceConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endChoiceErrorMessage, __LINE__);
        }
        if (is_null($end) || (is_array($end) && empty($end))) {
            unset($this->End);
        } else {
            $this->End = $end;
        }
        return $this;
    }
    /**
     * Get Duration value
     * @return \StructType\Duration|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDurationForChoiceConstraintsFromSetDuration($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'End',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Duration can\'t be set as the property %s is already set. Only one property must be set among these properties: Duration, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Duration value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Duration $duration
     * @return \StructType\StartAndEnd
     */
    public function setDuration(\StructType\Duration $duration = null)
    {
        // validation for constraint: choice(End, Duration)
        if ('' !== ($durationChoiceErrorMessage = self::validateDurationForChoiceConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationChoiceErrorMessage, __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartAndEnd
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
