<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecificSeatInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Known or specifically requested seat information.
 * @subpackage Structs
 */
class SpecificSeatInfo extends AbstractStructBase
{
    /**
     * The DeckLevel
     * Meta information extracted from the WSDL
     * - documentation: The level of the deck, e.g. "Upper."
     * - use: optional
     * @var string
     */
    public $DeckLevel;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: Sequence number of a row.
     * - use: optional
     * @var int
     */
    public $RowNumber;
    /**
     * The SeatInRow
     * Meta information extracted from the WSDL
     * - documentation: Seat number within a row without row designator, e.g. "C".
     * - use: optional
     * @var string
     */
    public $SeatInRow;
    /**
     * The SeatNumber
     * Meta information extracted from the WSDL
     * - documentation: Used to provide the seat number that includes a row identifier, e.g. 1C.
     * - use: optional
     * @var string
     */
    public $SeatNumber;
    /**
     * The TravelerRPH
     * @var string
     */
    public $TravelerRPH;
    /**
     * Constructor method for SpecificSeatInfo
     * @uses SpecificSeatInfo::setDeckLevel()
     * @uses SpecificSeatInfo::setRowNumber()
     * @uses SpecificSeatInfo::setSeatInRow()
     * @uses SpecificSeatInfo::setSeatNumber()
     * @uses SpecificSeatInfo::setTravelerRPH()
     * @param string $deckLevel
     * @param int $rowNumber
     * @param string $seatInRow
     * @param string $seatNumber
     * @param string $travelerRPH
     */
    public function __construct($deckLevel = null, $rowNumber = null, $seatInRow = null, $seatNumber = null, $travelerRPH = null)
    {
        $this
            ->setDeckLevel($deckLevel)
            ->setRowNumber($rowNumber)
            ->setSeatInRow($seatInRow)
            ->setSeatNumber($seatNumber)
            ->setTravelerRPH($travelerRPH);
    }
    /**
     * Get DeckLevel value
     * @return string|null
     */
    public function getDeckLevel()
    {
        return $this->DeckLevel;
    }
    /**
     * Set DeckLevel value
     * @param string $deckLevel
     * @return \StructType\SpecificSeatInfo
     */
    public function setDeckLevel($deckLevel = null)
    {
        // validation for constraint: string
        if (!is_null($deckLevel) && !is_string($deckLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deckLevel, true), gettype($deckLevel)), __LINE__);
        }
        $this->DeckLevel = $deckLevel;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SpecificSeatInfo
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get SeatInRow value
     * @return string|null
     */
    public function getSeatInRow()
    {
        return $this->SeatInRow;
    }
    /**
     * Set SeatInRow value
     * @param string $seatInRow
     * @return \StructType\SpecificSeatInfo
     */
    public function setSeatInRow($seatInRow = null)
    {
        // validation for constraint: string
        if (!is_null($seatInRow) && !is_string($seatInRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatInRow, true), gettype($seatInRow)), __LINE__);
        }
        $this->SeatInRow = $seatInRow;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \StructType\SpecificSeatInfo
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNumber, true), gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get TravelerRPH value
     * @return string|null
     */
    public function getTravelerRPH()
    {
        return $this->TravelerRPH;
    }
    /**
     * Set TravelerRPH value
     * @param string $travelerRPH
     * @return \StructType\SpecificSeatInfo
     */
    public function setTravelerRPH($travelerRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRPH) && !is_string($travelerRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerRPH, true), gettype($travelerRPH)), __LINE__);
        }
        $this->TravelerRPH = $travelerRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecificSeatInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
