<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecificFlightInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify actual airline, flight number, or booking class
 * @subpackage Structs
 */
class SpecificFlightInfoType extends AbstractStructBase
{
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: Specific flight number to request availability for. Requires that Airline is also supplied.
     * - minOccurs: 0
     * @var mixed
     */
    public $FlightNumber;
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: Specify airline to request availability for.
     * - minOccurs: 0
     * @var mixed
     */
    public $Airline;
    /**
     * The BookingClassPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\BookingClassPref[]
     */
    public $BookingClassPref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for SpecificFlightInfoType
     * @uses SpecificFlightInfoType::setFlightNumber()
     * @uses SpecificFlightInfoType::setAirline()
     * @uses SpecificFlightInfoType::setBookingClassPref()
     * @uses SpecificFlightInfoType::setTPA_Extensions()
     * @param mixed $flightNumber
     * @param mixed $airline
     * @param \StructType\BookingClassPref[] $bookingClassPref
     * @param mixed $tPA_Extensions
     */
    public function __construct($flightNumber = null, $airline = null, array $bookingClassPref = array(), $tPA_Extensions = null)
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setAirline($airline)
            ->setBookingClassPref($bookingClassPref)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get FlightNumber value
     * @return mixed|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param mixed $flightNumber
     * @return \StructType\SpecificFlightInfoType
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Airline value
     * @return mixed|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param mixed $airline
     * @return \StructType\SpecificFlightInfoType
     */
    public function setAirline($airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get BookingClassPref value
     * @return \StructType\BookingClassPref[]|null
     */
    public function getBookingClassPref()
    {
        return $this->BookingClassPref;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingClassPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingClassPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingClassPrefForArrayConstraintsFromSetBookingClassPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specificFlightInfoTypeBookingClassPrefItem) {
            // validation for constraint: itemType
            if (!$specificFlightInfoTypeBookingClassPrefItem instanceof \StructType\BookingClassPref) {
                $invalidValues[] = is_object($specificFlightInfoTypeBookingClassPrefItem) ? get_class($specificFlightInfoTypeBookingClassPrefItem) : sprintf('%s(%s)', gettype($specificFlightInfoTypeBookingClassPrefItem), var_export($specificFlightInfoTypeBookingClassPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingClassPref property can only contain items of type \StructType\BookingClassPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingClassPref value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassPref[] $bookingClassPref
     * @return \StructType\SpecificFlightInfoType
     */
    public function setBookingClassPref(array $bookingClassPref = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingClassPrefArrayErrorMessage = self::validateBookingClassPrefForArrayConstraintsFromSetBookingClassPref($bookingClassPref))) {
            throw new \InvalidArgumentException($bookingClassPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($bookingClassPref) && count($bookingClassPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($bookingClassPref)), __LINE__);
        }
        $this->BookingClassPref = $bookingClassPref;
        return $this;
    }
    /**
     * Add item to BookingClassPref value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassPref $item
     * @return \StructType\SpecificFlightInfoType
     */
    public function addToBookingClassPref(\StructType\BookingClassPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingClassPref) {
            throw new \InvalidArgumentException(sprintf('The BookingClassPref property can only contain items of type \StructType\BookingClassPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->BookingClassPref) && count($this->BookingClassPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->BookingClassPref)), __LINE__);
        }
        $this->BookingClassPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\SpecificFlightInfoType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecificFlightInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
