<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialReqDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Remarks, OSIs, Seat Requests etc.
 * @subpackage Structs
 */
class SpecialReqDetailsType extends AbstractStructBase
{
    /**
     * The SeatRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SeatRequests
     */
    public $SeatRequests;
    /**
     * The SpecialServiceRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SpecialServiceRequests
     */
    public $SpecialServiceRequests;
    /**
     * The OtherServiceInformations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OtherServiceInformations
     */
    public $OtherServiceInformations;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Remarks
     */
    public $Remarks;
    /**
     * The SpecialRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SpecialRemarks
     */
    public $SpecialRemarks;
    /**
     * Constructor method for SpecialReqDetailsType
     * @uses SpecialReqDetailsType::setSeatRequests()
     * @uses SpecialReqDetailsType::setSpecialServiceRequests()
     * @uses SpecialReqDetailsType::setOtherServiceInformations()
     * @uses SpecialReqDetailsType::setRemarks()
     * @uses SpecialReqDetailsType::setSpecialRemarks()
     * @param \StructType\SeatRequests $seatRequests
     * @param \StructType\SpecialServiceRequests $specialServiceRequests
     * @param \StructType\OtherServiceInformations $otherServiceInformations
     * @param \StructType\Remarks $remarks
     * @param \StructType\SpecialRemarks $specialRemarks
     */
    public function __construct(\StructType\SeatRequests $seatRequests = null, \StructType\SpecialServiceRequests $specialServiceRequests = null, \StructType\OtherServiceInformations $otherServiceInformations = null, \StructType\Remarks $remarks = null, \StructType\SpecialRemarks $specialRemarks = null)
    {
        $this
            ->setSeatRequests($seatRequests)
            ->setSpecialServiceRequests($specialServiceRequests)
            ->setOtherServiceInformations($otherServiceInformations)
            ->setRemarks($remarks)
            ->setSpecialRemarks($specialRemarks);
    }
    /**
     * Get SeatRequests value
     * @return \StructType\SeatRequests|null
     */
    public function getSeatRequests()
    {
        return $this->SeatRequests;
    }
    /**
     * Set SeatRequests value
     * @param \StructType\SeatRequests $seatRequests
     * @return \StructType\SpecialReqDetailsType
     */
    public function setSeatRequests(\StructType\SeatRequests $seatRequests = null)
    {
        $this->SeatRequests = $seatRequests;
        return $this;
    }
    /**
     * Get SpecialServiceRequests value
     * @return \StructType\SpecialServiceRequests|null
     */
    public function getSpecialServiceRequests()
    {
        return $this->SpecialServiceRequests;
    }
    /**
     * Set SpecialServiceRequests value
     * @param \StructType\SpecialServiceRequests $specialServiceRequests
     * @return \StructType\SpecialReqDetailsType
     */
    public function setSpecialServiceRequests(\StructType\SpecialServiceRequests $specialServiceRequests = null)
    {
        $this->SpecialServiceRequests = $specialServiceRequests;
        return $this;
    }
    /**
     * Get OtherServiceInformations value
     * @return \StructType\OtherServiceInformations|null
     */
    public function getOtherServiceInformations()
    {
        return $this->OtherServiceInformations;
    }
    /**
     * Set OtherServiceInformations value
     * @param \StructType\OtherServiceInformations $otherServiceInformations
     * @return \StructType\SpecialReqDetailsType
     */
    public function setOtherServiceInformations(\StructType\OtherServiceInformations $otherServiceInformations = null)
    {
        $this->OtherServiceInformations = $otherServiceInformations;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \StructType\Remarks|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \StructType\Remarks $remarks
     * @return \StructType\SpecialReqDetailsType
     */
    public function setRemarks(\StructType\Remarks $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get SpecialRemarks value
     * @return \StructType\SpecialRemarks|null
     */
    public function getSpecialRemarks()
    {
        return $this->SpecialRemarks;
    }
    /**
     * Set SpecialRemarks value
     * @param \StructType\SpecialRemarks $specialRemarks
     * @return \StructType\SpecialReqDetailsType
     */
    public function setSpecialRemarks(\StructType\SpecialRemarks $specialRemarks = null)
    {
        $this->SpecialRemarks = $specialRemarks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialReqDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
