<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRemarks StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Special Remark.
 * @subpackage Structs
 */
class SpecialRemarks extends AbstractStructBase
{
    /**
     * The SpecialRemark
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SpecialRemark[]
     */
    public $SpecialRemark;
    /**
     * Constructor method for SpecialRemarks
     * @uses SpecialRemarks::setSpecialRemark()
     * @param \StructType\SpecialRemark[] $specialRemark
     */
    public function __construct(array $specialRemark = array())
    {
        $this
            ->setSpecialRemark($specialRemark);
    }
    /**
     * Get SpecialRemark value
     * @return \StructType\SpecialRemark[]|null
     */
    public function getSpecialRemark()
    {
        return $this->SpecialRemark;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialRemarkForArrayConstraintsFromSetSpecialRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialRemarksSpecialRemarkItem) {
            // validation for constraint: itemType
            if (!$specialRemarksSpecialRemarkItem instanceof \StructType\SpecialRemark) {
                $invalidValues[] = is_object($specialRemarksSpecialRemarkItem) ? get_class($specialRemarksSpecialRemarkItem) : sprintf('%s(%s)', gettype($specialRemarksSpecialRemarkItem), var_export($specialRemarksSpecialRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialRemark property can only contain items of type \StructType\SpecialRemark, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialRemark value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialRemark[] $specialRemark
     * @return \StructType\SpecialRemarks
     */
    public function setSpecialRemark(array $specialRemark = array())
    {
        // validation for constraint: array
        if ('' !== ($specialRemarkArrayErrorMessage = self::validateSpecialRemarkForArrayConstraintsFromSetSpecialRemark($specialRemark))) {
            throw new \InvalidArgumentException($specialRemarkArrayErrorMessage, __LINE__);
        }
        $this->SpecialRemark = $specialRemark;
        return $this;
    }
    /**
     * Add item to SpecialRemark value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialRemark $item
     * @return \StructType\SpecialRemarks
     */
    public function addToSpecialRemark(\StructType\SpecialRemark $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialRemark) {
            throw new \InvalidArgumentException(sprintf('The SpecialRemark property can only contain items of type \StructType\SpecialRemark, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialRemark[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialRemarks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
