<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialEquipPrefs StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the preferences for one or more specific items of additional equipment, such as ski racks, child seats, etc. | Special equipment preferences.
 * @subpackage Structs
 */
class SpecialEquipPrefs extends AbstractStructBase
{
    /**
     * The SpecialEquipPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 15
     * @var \StructType\SpecialEquipPref[]
     */
    public $SpecialEquipPref;
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - documentation: Used when the customer was previously quoted a rate for the equipment in an availability search response.
     * - minOccurs: 0
     * @var mixed
     */
    public $Charge;
    /**
     * Constructor method for SpecialEquipPrefs
     * @uses SpecialEquipPrefs::setSpecialEquipPref()
     * @uses SpecialEquipPrefs::setCharge()
     * @param \StructType\SpecialEquipPref[] $specialEquipPref
     * @param mixed $charge
     */
    public function __construct(array $specialEquipPref = array(), $charge = null)
    {
        $this
            ->setSpecialEquipPref($specialEquipPref)
            ->setCharge($charge);
    }
    /**
     * Get SpecialEquipPref value
     * @return \StructType\SpecialEquipPref[]|null
     */
    public function getSpecialEquipPref()
    {
        return $this->SpecialEquipPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialEquipPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialEquipPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialEquipPrefForArrayConstraintsFromSetSpecialEquipPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialEquipPrefsSpecialEquipPrefItem) {
            // validation for constraint: itemType
            if (!$specialEquipPrefsSpecialEquipPrefItem instanceof \StructType\SpecialEquipPref) {
                $invalidValues[] = is_object($specialEquipPrefsSpecialEquipPrefItem) ? get_class($specialEquipPrefsSpecialEquipPrefItem) : sprintf('%s(%s)', gettype($specialEquipPrefsSpecialEquipPrefItem), var_export($specialEquipPrefsSpecialEquipPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialEquipPref property can only contain items of type \StructType\SpecialEquipPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialEquipPref[] $specialEquipPref
     * @return \StructType\SpecialEquipPrefs
     */
    public function setSpecialEquipPref(array $specialEquipPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specialEquipPrefArrayErrorMessage = self::validateSpecialEquipPrefForArrayConstraintsFromSetSpecialEquipPref($specialEquipPref))) {
            throw new \InvalidArgumentException($specialEquipPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($specialEquipPref) && count($specialEquipPref) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 15', count($specialEquipPref)), __LINE__);
        }
        $this->SpecialEquipPref = $specialEquipPref;
        return $this;
    }
    /**
     * Add item to SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialEquipPref $item
     * @return \StructType\SpecialEquipPrefs
     */
    public function addToSpecialEquipPref(\StructType\SpecialEquipPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialEquipPref) {
            throw new \InvalidArgumentException(sprintf('The SpecialEquipPref property can only contain items of type \StructType\SpecialEquipPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($this->SpecialEquipPref) && count($this->SpecialEquipPref) >= 15) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 15', count($this->SpecialEquipPref)), __LINE__);
        }
        $this->SpecialEquipPref[] = $item;
        return $this;
    }
    /**
     * Get Charge value
     * @return mixed|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param mixed $charge
     * @return \StructType\SpecialEquipPrefs
     */
    public function setCharge($charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialEquipPrefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
