<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information on the source of a request.
 * @subpackage Structs
 */
class SourceType extends AbstractStructBase
{
    /**
     * The RequestorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RequestorID
     */
    public $RequestorID;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The BookingChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingChannel
     */
    public $BookingChannel;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The AgentSine
     * Meta information extracted from the WSDL
     * - documentation: Identifies the party within the requesting entity.
     * - use: optional
     * @var string
     */
    public $AgentSine;
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system.
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The ISOCountry
     * Meta information extracted from the WSDL
     * - documentation: ISO 3166-3 character country codes: url=http://simple.wikipedia.org/wiki/ISO_3166-1_alpha-3 | The country code of the requesting party in ISO 3166-3 encoding.
     * - use: optional
     * @var string
     */
    public $ISOCountry;
    /**
     * The ISOCurrency
     * Meta information extracted from the WSDL
     * - documentation: http://www.iso.org/iso/support/currency_codes_list-1.htm | The currency code in which the reservation will be ticketed in ISO 4217-3 encoding.
     * - use: optional
     * @var string
     */
    public $ISOCurrency;
    /**
     * The AgentDutyCode
     * Meta information extracted from the WSDL
     * - documentation: An authority code assigned to a requestor.
     * - use: optional
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The AirlineVendorID
     * Meta information extracted from the WSDL
     * - documentation: The IATA assigned airline code.
     * - use: optional
     * @var string
     */
    public $AirlineVendorID;
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - documentation: The IATA assigned airport code.
     * - use: optional
     * @var string
     */
    public $AirportCode;
    /**
     * The FirstDepartPoint
     * Meta information extracted from the WSDL
     * - documentation: The point of first departure in a trip.
     * - use: optional
     * @var string
     */
    public $FirstDepartPoint;
    /**
     * The ERSP_UserID
     * Meta information extracted from the WSDL
     * - documentation: Electronic Reservation Service Provider (ERSP) assigned identifier used to identify the individual using the ERSP system.
     * - use: optional
     * @var string
     */
    public $ERSP_UserID;
    /**
     * The TerminalID
     * Meta information extracted from the WSDL
     * - documentation: This is the electronic address of the device from which information is entered.
     * - use: optional
     * @var string
     */
    public $TerminalID;
    /**
     * Constructor method for SourceType
     * @uses SourceType::setRequestorID()
     * @uses SourceType::setPosition()
     * @uses SourceType::setBookingChannel()
     * @uses SourceType::setTPA_Extensions()
     * @uses SourceType::setAgentSine()
     * @uses SourceType::setPseudoCityCode()
     * @uses SourceType::setISOCountry()
     * @uses SourceType::setISOCurrency()
     * @uses SourceType::setAgentDutyCode()
     * @uses SourceType::setAirlineVendorID()
     * @uses SourceType::setAirportCode()
     * @uses SourceType::setFirstDepartPoint()
     * @uses SourceType::setERSP_UserID()
     * @uses SourceType::setTerminalID()
     * @param \StructType\RequestorID $requestorID
     * @param \StructType\Position $position
     * @param \StructType\BookingChannel $bookingChannel
     * @param mixed $tPA_Extensions
     * @param string $agentSine
     * @param string $pseudoCityCode
     * @param string $iSOCountry
     * @param string $iSOCurrency
     * @param string $agentDutyCode
     * @param string $airlineVendorID
     * @param string $airportCode
     * @param string $firstDepartPoint
     * @param string $eRSP_UserID
     * @param string $terminalID
     */
    public function __construct(\StructType\RequestorID $requestorID = null, \StructType\Position $position = null, \StructType\BookingChannel $bookingChannel = null, $tPA_Extensions = null, $agentSine = null, $pseudoCityCode = null, $iSOCountry = null, $iSOCurrency = null, $agentDutyCode = null, $airlineVendorID = null, $airportCode = null, $firstDepartPoint = null, $eRSP_UserID = null, $terminalID = null)
    {
        $this
            ->setRequestorID($requestorID)
            ->setPosition($position)
            ->setBookingChannel($bookingChannel)
            ->setTPA_Extensions($tPA_Extensions)
            ->setAgentSine($agentSine)
            ->setPseudoCityCode($pseudoCityCode)
            ->setISOCountry($iSOCountry)
            ->setISOCurrency($iSOCurrency)
            ->setAgentDutyCode($agentDutyCode)
            ->setAirlineVendorID($airlineVendorID)
            ->setAirportCode($airportCode)
            ->setFirstDepartPoint($firstDepartPoint)
            ->setERSP_UserID($eRSP_UserID)
            ->setTerminalID($terminalID);
    }
    /**
     * Get RequestorID value
     * @return \StructType\RequestorID|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param \StructType\RequestorID $requestorID
     * @return \StructType\SourceType
     */
    public function setRequestorID(\StructType\RequestorID $requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\SourceType
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return \StructType\BookingChannel|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \StructType\BookingChannel $bookingChannel
     * @return \StructType\SourceType
     */
    public function setBookingChannel(\StructType\BookingChannel $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\SourceType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \StructType\SourceType
     */
    public function setAgentSine($agentSine = null)
    {
        // validation for constraint: string
        if (!is_null($agentSine) && !is_string($agentSine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentSine, true), gettype($agentSine)), __LINE__);
        }
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \StructType\SourceType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pseudoCityCode, true), gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \StructType\SourceType
     */
    public function setISOCountry($iSOCountry = null)
    {
        // validation for constraint: string
        if (!is_null($iSOCountry) && !is_string($iSOCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSOCountry, true), gettype($iSOCountry)), __LINE__);
        }
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get ISOCurrency value
     * @return string|null
     */
    public function getISOCurrency()
    {
        return $this->ISOCurrency;
    }
    /**
     * Set ISOCurrency value
     * @param string $iSOCurrency
     * @return \StructType\SourceType
     */
    public function setISOCurrency($iSOCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($iSOCurrency) && !is_string($iSOCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSOCurrency, true), gettype($iSOCurrency)), __LINE__);
        }
        $this->ISOCurrency = $iSOCurrency;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \StructType\SourceType
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentDutyCode) && !is_string($agentDutyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentDutyCode, true), gettype($agentDutyCode)), __LINE__);
        }
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get AirlineVendorID value
     * @return string|null
     */
    public function getAirlineVendorID()
    {
        return $this->AirlineVendorID;
    }
    /**
     * Set AirlineVendorID value
     * @param string $airlineVendorID
     * @return \StructType\SourceType
     */
    public function setAirlineVendorID($airlineVendorID = null)
    {
        // validation for constraint: string
        if (!is_null($airlineVendorID) && !is_string($airlineVendorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineVendorID, true), gettype($airlineVendorID)), __LINE__);
        }
        $this->AirlineVendorID = $airlineVendorID;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \StructType\SourceType
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportCode, true), gettype($airportCode)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get FirstDepartPoint value
     * @return string|null
     */
    public function getFirstDepartPoint()
    {
        return $this->FirstDepartPoint;
    }
    /**
     * Set FirstDepartPoint value
     * @param string $firstDepartPoint
     * @return \StructType\SourceType
     */
    public function setFirstDepartPoint($firstDepartPoint = null)
    {
        // validation for constraint: string
        if (!is_null($firstDepartPoint) && !is_string($firstDepartPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstDepartPoint, true), gettype($firstDepartPoint)), __LINE__);
        }
        $this->FirstDepartPoint = $firstDepartPoint;
        return $this;
    }
    /**
     * Get ERSP_UserID value
     * @return string|null
     */
    public function getERSP_UserID()
    {
        return $this->ERSP_UserID;
    }
    /**
     * Set ERSP_UserID value
     * @param string $eRSP_UserID
     * @return \StructType\SourceType
     */
    public function setERSP_UserID($eRSP_UserID = null)
    {
        // validation for constraint: string
        if (!is_null($eRSP_UserID) && !is_string($eRSP_UserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRSP_UserID, true), gettype($eRSP_UserID)), __LINE__);
        }
        $this->ERSP_UserID = $eRSP_UserID;
        return $this;
    }
    /**
     * Get TerminalID value
     * @return string|null
     */
    public function getTerminalID()
    {
        return $this->TerminalID;
    }
    /**
     * Set TerminalID value
     * @param string $terminalID
     * @return \StructType\SourceType
     */
    public function setTerminalID($terminalID = null)
    {
        // validation for constraint: string
        if (!is_null($terminalID) && !is_string($terminalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalID, true), gettype($terminalID)), __LINE__);
        }
        $this->TerminalID = $terminalID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
