<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureOnFile StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the date range for which the signature is accepted for a guarantee. | Note: This indicates if the signature is authorized as a form of guarantee. In some countries, the customer can sign the payment card slip as a form of
 * guarantee. | Signature on file.
 * @subpackage Structs
 */
class SignatureOnFile extends AbstractStructBase
{
    /**
     * The SignatureOnFileInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates a signature has been obtained.
     * - use: optional
     * @var bool
     */
    public $SignatureOnFileInd;
    /**
     * Constructor method for SignatureOnFile
     * @uses SignatureOnFile::setSignatureOnFileInd()
     * @param bool $signatureOnFileInd
     */
    public function __construct($signatureOnFileInd = null)
    {
        $this
            ->setSignatureOnFileInd($signatureOnFileInd);
    }
    /**
     * Get SignatureOnFileInd value
     * @return bool|null
     */
    public function getSignatureOnFileInd()
    {
        return $this->SignatureOnFileInd;
    }
    /**
     * Set SignatureOnFileInd value
     * @param bool $signatureOnFileInd
     * @return \StructType\SignatureOnFile
     */
    public function setSignatureOnFileInd($signatureOnFileInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($signatureOnFileInd) && !is_bool($signatureOnFileInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signatureOnFileInd, true), gettype($signatureOnFileInd)), __LINE__);
        }
        $this->SignatureOnFileInd = $signatureOnFileInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignatureOnFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
