<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShuttleInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Textual description about a specific aspect of the Shuttle Services
 * @subpackage Structs
 */
class ShuttleInfo extends FormattedTextType
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Identifies the type of Shuttle service information.
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * Constructor method for ShuttleInfo
     * @uses ShuttleInfo::setType()
     * @param string $type
     */
    public function __construct($type = null)
    {
        $this
            ->setType($type);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\LocationDetailShuttleInfoType::valueIsValid()
     * @uses \EnumType\LocationDetailShuttleInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ShuttleInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationDetailShuttleInfoType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LocationDetailShuttleInfoType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\LocationDetailShuttleInfoType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShuttleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
