<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies a vendor and ship. | Defines the ship details.
 * @subpackage Structs
 */
class ShipInfoType extends AbstractStructBase
{
    /**
     * The Ship
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Ship
     */
    public $Ship;
    /**
     * The ShipLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipLength
     */
    public $ShipLength;
    /**
     * The ShipVoltage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipVoltage
     */
    public $ShipVoltage;
    /**
     * Constructor method for ShipInfoType
     * @uses ShipInfoType::setShip()
     * @uses ShipInfoType::setShipLength()
     * @uses ShipInfoType::setShipVoltage()
     * @param \StructType\Ship $ship
     * @param \StructType\ShipLength $shipLength
     * @param \StructType\ShipVoltage $shipVoltage
     */
    public function __construct(\StructType\Ship $ship = null, \StructType\ShipLength $shipLength = null, \StructType\ShipVoltage $shipVoltage = null)
    {
        $this
            ->setShip($ship)
            ->setShipLength($shipLength)
            ->setShipVoltage($shipVoltage);
    }
    /**
     * Get Ship value
     * @return \StructType\Ship|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \StructType\Ship $ship
     * @return \StructType\ShipInfoType
     */
    public function setShip(\StructType\Ship $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get ShipLength value
     * @return \StructType\ShipLength|null
     */
    public function getShipLength()
    {
        return $this->ShipLength;
    }
    /**
     * Set ShipLength value
     * @param \StructType\ShipLength $shipLength
     * @return \StructType\ShipInfoType
     */
    public function setShipLength(\StructType\ShipLength $shipLength = null)
    {
        $this->ShipLength = $shipLength;
        return $this;
    }
    /**
     * Get ShipVoltage value
     * @return \StructType\ShipVoltage|null
     */
    public function getShipVoltage()
    {
        return $this->ShipVoltage;
    }
    /**
     * Set ShipVoltage value
     * @param \StructType\ShipVoltage $shipVoltage
     * @return \StructType\ShipInfoType
     */
    public function setShipVoltage(\StructType\ShipVoltage $shipVoltage = null)
    {
        $this->ShipVoltage = $shipVoltage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
