<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicesType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Service objects. This is the collection of all services associated with any part of this reservation (the reservation in its entirety, one or more guests, or one or more room stays). Which services are attributable to
 * which part is determined by each object's ServiceRPHs collection.
 * @subpackage Structs
 */
class ServicesType extends AbstractStructBase
{
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: A Service object represents a non-room product provided to guests. Service products may have associated inventory and charges.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $Service;
    /**
     * The ServiceCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceCategory[]
     */
    public $ServiceCategory;
    /**
     * Constructor method for ServicesType
     * @uses ServicesType::setService()
     * @uses ServicesType::setServiceCategory()
     * @param mixed[] $service
     * @param \StructType\ServiceCategory[] $serviceCategory
     */
    public function __construct(array $service = array(), array $serviceCategory = array())
    {
        $this
            ->setService($service)
            ->setServiceCategory($serviceCategory);
    }
    /**
     * Get Service value
     * @return mixed[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $servicesTypeServiceItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($servicesTypeServiceItem) ? get_class($servicesTypeServiceItem) : sprintf('%s(%s)', gettype($servicesTypeServiceItem), var_export($servicesTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param mixed[] $service
     * @return \StructType\ServicesType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ServicesType
     */
    public function addToService($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get ServiceCategory value
     * @return \StructType\ServiceCategory[]|null
     */
    public function getServiceCategory()
    {
        return $this->ServiceCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceCategoryForArrayConstraintsFromSetServiceCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $servicesTypeServiceCategoryItem) {
            // validation for constraint: itemType
            if (!$servicesTypeServiceCategoryItem instanceof \StructType\ServiceCategory) {
                $invalidValues[] = is_object($servicesTypeServiceCategoryItem) ? get_class($servicesTypeServiceCategoryItem) : sprintf('%s(%s)', gettype($servicesTypeServiceCategoryItem), var_export($servicesTypeServiceCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceCategory property can only contain items of type \StructType\ServiceCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCategory[] $serviceCategory
     * @return \StructType\ServicesType
     */
    public function setServiceCategory(array $serviceCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceCategoryArrayErrorMessage = self::validateServiceCategoryForArrayConstraintsFromSetServiceCategory($serviceCategory))) {
            throw new \InvalidArgumentException($serviceCategoryArrayErrorMessage, __LINE__);
        }
        $this->ServiceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Add item to ServiceCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCategory $item
     * @return \StructType\ServicesType
     */
    public function addToServiceCategory(\StructType\ServiceCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceCategory) {
            throw new \InvalidArgumentException(sprintf('The ServiceCategory property can only contain items of type \StructType\ServiceCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceCategory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServicesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
