<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Details on the Service including Guest Counts, Time Span of this Service, pointers to Res Guests, guest Memberships, Comments and Special Requests pertaining to this particular Service and finally financial information related to the
 * Service, including Guarantee, Deposit and Payment and Cancellation Penalties.
 * @subpackage Structs
 */
class ServiceDetails extends ResCommonDetailType
{
    /**
     * The ServiceDescription
     * Meta information extracted from the WSDL
     * - documentation: Description of the service.
     * - minOccurs: 0
     * @var mixed
     */
    public $ServiceDescription;
    /**
     * Constructor method for ServiceDetails
     * @uses ServiceDetails::setServiceDescription()
     * @param mixed $serviceDescription
     */
    public function __construct($serviceDescription = null)
    {
        $this
            ->setServiceDescription($serviceDescription);
    }
    /**
     * Get ServiceDescription value
     * @return mixed|null
     */
    public function getServiceDescription()
    {
        return $this->ServiceDescription;
    }
    /**
     * Set ServiceDescription value
     * @param mixed $serviceDescription
     * @return \StructType\ServiceDetails
     */
    public function setServiceDescription($serviceDescription = null)
    {
        $this->ServiceDescription = $serviceDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
