<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceCategory StructType
 * Meta information extracted from the WSDL
 * - documentation: Hotel systems often group multiple services into a single category. This refers to that category that is specific to the hotel CRS/PMS.
 * @subpackage Structs
 */
class ServiceCategory extends AbstractStructBase
{
    /**
     * The ServiceCatetoryCode
     * Meta information extracted from the WSDL
     * - documentation: The representation of the specific service category for the service being reserved.
     * - use: required
     * @var string
     */
    public $ServiceCatetoryCode;
    /**
     * The RequiredInd
     * Meta information extracted from the WSDL
     * - documentation: Example: true | When true, a service from the service category is required and/or mandatory.
     * @var bool
     */
    public $RequiredInd;
    /**
     * Constructor method for ServiceCategory
     * @uses ServiceCategory::setServiceCatetoryCode()
     * @uses ServiceCategory::setRequiredInd()
     * @param string $serviceCatetoryCode
     * @param bool $requiredInd
     */
    public function __construct($serviceCatetoryCode = null, $requiredInd = null)
    {
        $this
            ->setServiceCatetoryCode($serviceCatetoryCode)
            ->setRequiredInd($requiredInd);
    }
    /**
     * Get ServiceCatetoryCode value
     * @return string
     */
    public function getServiceCatetoryCode()
    {
        return $this->ServiceCatetoryCode;
    }
    /**
     * Set ServiceCatetoryCode value
     * @param string $serviceCatetoryCode
     * @return \StructType\ServiceCategory
     */
    public function setServiceCatetoryCode($serviceCatetoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCatetoryCode) && !is_string($serviceCatetoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCatetoryCode, true), gettype($serviceCatetoryCode)), __LINE__);
        }
        $this->ServiceCatetoryCode = $serviceCatetoryCode;
        return $this;
    }
    /**
     * Get RequiredInd value
     * @return bool|null
     */
    public function getRequiredInd()
    {
        return $this->RequiredInd;
    }
    /**
     * Set RequiredInd value
     * @param bool $requiredInd
     * @return \StructType\ServiceCategory
     */
    public function setRequiredInd($requiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiredInd) && !is_bool($requiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiredInd, true), gettype($requiredInd)), __LINE__);
        }
        $this->RequiredInd = $requiredInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
