<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedCategory StructType
 * Meta information extracted from the WSDL
 * - documentation: The fare requested for this category. | Specificies cruise category information. | Specifies a selected cabin category.
 * @subpackage Structs
 */
class SelectedCategory extends AbstractStructBase
{
    /**
     * The CabinAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CabinAttributes
     */
    public $CabinAttributes;
    /**
     * The SelectedCabin
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\SelectedCabin[]
     */
    public $SelectedCabin;
    /**
     * The WaitlistIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, this indicates the selected category is waitlisted.
     * - use: optional
     * @var bool
     */
    public $WaitlistIndicator;
    /**
     * Constructor method for SelectedCategory
     * @uses SelectedCategory::setCabinAttributes()
     * @uses SelectedCategory::setSelectedCabin()
     * @uses SelectedCategory::setWaitlistIndicator()
     * @param \StructType\CabinAttributes $cabinAttributes
     * @param \StructType\SelectedCabin[] $selectedCabin
     * @param bool $waitlistIndicator
     */
    public function __construct(\StructType\CabinAttributes $cabinAttributes = null, array $selectedCabin = array(), $waitlistIndicator = null)
    {
        $this
            ->setCabinAttributes($cabinAttributes)
            ->setSelectedCabin($selectedCabin)
            ->setWaitlistIndicator($waitlistIndicator);
    }
    /**
     * Get CabinAttributes value
     * @return \StructType\CabinAttributes|null
     */
    public function getCabinAttributes()
    {
        return $this->CabinAttributes;
    }
    /**
     * Set CabinAttributes value
     * @param \StructType\CabinAttributes $cabinAttributes
     * @return \StructType\SelectedCategory
     */
    public function setCabinAttributes(\StructType\CabinAttributes $cabinAttributes = null)
    {
        $this->CabinAttributes = $cabinAttributes;
        return $this;
    }
    /**
     * Get SelectedCabin value
     * @return \StructType\SelectedCabin[]|null
     */
    public function getSelectedCabin()
    {
        return $this->SelectedCabin;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedCabin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedCabin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedCabinForArrayConstraintsFromSetSelectedCabin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $selectedCategorySelectedCabinItem) {
            // validation for constraint: itemType
            if (!$selectedCategorySelectedCabinItem instanceof \StructType\SelectedCabin) {
                $invalidValues[] = is_object($selectedCategorySelectedCabinItem) ? get_class($selectedCategorySelectedCabinItem) : sprintf('%s(%s)', gettype($selectedCategorySelectedCabinItem), var_export($selectedCategorySelectedCabinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedCabin property can only contain items of type \StructType\SelectedCabin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedCabin value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedCabin[] $selectedCabin
     * @return \StructType\SelectedCategory
     */
    public function setSelectedCabin(array $selectedCabin = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedCabinArrayErrorMessage = self::validateSelectedCabinForArrayConstraintsFromSetSelectedCabin($selectedCabin))) {
            throw new \InvalidArgumentException($selectedCabinArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($selectedCabin) && count($selectedCabin) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($selectedCabin)), __LINE__);
        }
        $this->SelectedCabin = $selectedCabin;
        return $this;
    }
    /**
     * Add item to SelectedCabin value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedCabin $item
     * @return \StructType\SelectedCategory
     */
    public function addToSelectedCabin(\StructType\SelectedCabin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedCabin) {
            throw new \InvalidArgumentException(sprintf('The SelectedCabin property can only contain items of type \StructType\SelectedCabin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->SelectedCabin) && count($this->SelectedCabin) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->SelectedCabin)), __LINE__);
        }
        $this->SelectedCabin[] = $item;
        return $this;
    }
    /**
     * Get WaitlistIndicator value
     * @return bool|null
     */
    public function getWaitlistIndicator()
    {
        return $this->WaitlistIndicator;
    }
    /**
     * Set WaitlistIndicator value
     * @param bool $waitlistIndicator
     * @return \StructType\SelectedCategory
     */
    public function setWaitlistIndicator($waitlistIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($waitlistIndicator) && !is_bool($waitlistIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($waitlistIndicator, true), gettype($waitlistIndicator)), __LINE__);
        }
        $this->WaitlistIndicator = $waitlistIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SelectedCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
