<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatZoneQueryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Query criteria related to a zone of seating.
 * @subpackage Structs
 */
class SeatZoneQueryType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The unique seat zone ID.
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the seat zone.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The AllSeatsInd
     * Meta information extracted from the WSDL
     * - documentation: If true, return all seats in the seat zone, with and without availability.
     * - use: optional
     * @var bool
     */
    public $AllSeatsInd;
    /**
     * The AvailSeatsOnlyInd
     * Meta information extracted from the WSDL
     * - documentation: If true, return only seats with availability in the requested seat zone.
     * - use: optional
     * @var bool
     */
    public $AvailSeatsOnlyInd;
    /**
     * The IncludeExclude
     * Meta information extracted from the WSDL
     * - documentation: Select "include" to include the specified seat zone in the search results, or "exclude" to exclude it from search results.
     * - use: optional
     * @var string
     */
    public $IncludeExclude;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for SeatZoneQueryType
     * @uses SeatZoneQueryType::set_()
     * @uses SeatZoneQueryType::setID()
     * @uses SeatZoneQueryType::setName()
     * @uses SeatZoneQueryType::setAllSeatsInd()
     * @uses SeatZoneQueryType::setAvailSeatsOnlyInd()
     * @uses SeatZoneQueryType::setIncludeExclude()
     * @uses SeatZoneQueryType::setType()
     * @param string $_
     * @param string $iD
     * @param string $name
     * @param bool $allSeatsInd
     * @param bool $availSeatsOnlyInd
     * @param string $includeExclude
     * @param string $type
     */
    public function __construct($_ = null, $iD = null, $name = null, $allSeatsInd = null, $availSeatsOnlyInd = null, $includeExclude = null, $type = null)
    {
        $this
            ->set_($_)
            ->setID($iD)
            ->setName($name)
            ->setAllSeatsInd($allSeatsInd)
            ->setAvailSeatsOnlyInd($availSeatsOnlyInd)
            ->setIncludeExclude($includeExclude)
            ->setType($type);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\SeatZoneQueryType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\SeatZoneQueryType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SeatZoneQueryType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AllSeatsInd value
     * @return bool|null
     */
    public function getAllSeatsInd()
    {
        return $this->AllSeatsInd;
    }
    /**
     * Set AllSeatsInd value
     * @param bool $allSeatsInd
     * @return \StructType\SeatZoneQueryType
     */
    public function setAllSeatsInd($allSeatsInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allSeatsInd) && !is_bool($allSeatsInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allSeatsInd, true), gettype($allSeatsInd)), __LINE__);
        }
        $this->AllSeatsInd = $allSeatsInd;
        return $this;
    }
    /**
     * Get AvailSeatsOnlyInd value
     * @return bool|null
     */
    public function getAvailSeatsOnlyInd()
    {
        return $this->AvailSeatsOnlyInd;
    }
    /**
     * Set AvailSeatsOnlyInd value
     * @param bool $availSeatsOnlyInd
     * @return \StructType\SeatZoneQueryType
     */
    public function setAvailSeatsOnlyInd($availSeatsOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($availSeatsOnlyInd) && !is_bool($availSeatsOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availSeatsOnlyInd, true), gettype($availSeatsOnlyInd)), __LINE__);
        }
        $this->AvailSeatsOnlyInd = $availSeatsOnlyInd;
        return $this;
    }
    /**
     * Get IncludeExclude value
     * @return string|null
     */
    public function getIncludeExclude()
    {
        return $this->IncludeExclude;
    }
    /**
     * Set IncludeExclude value
     * @uses \EnumType\IncludeExcludeType::valueIsValid()
     * @uses \EnumType\IncludeExcludeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeExclude
     * @return \StructType\SeatZoneQueryType
     */
    public function setIncludeExclude($includeExclude = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IncludeExcludeType::valueIsValid($includeExclude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IncludeExcludeType', is_array($includeExclude) ? implode(', ', $includeExclude) : var_export($includeExclude, true), implode(', ', \EnumType\IncludeExcludeType::getValidValues())), __LINE__);
        }
        $this->IncludeExclude = $includeExclude;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\SeatZoneQueryType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatZoneQueryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
