<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Attributes for seat request. Note: you can choose a specific seat or just a general preference | Object to hold a passengers' seat request
 * @subpackage Structs
 */
class SeatRequestType extends AbstractStructBase
{
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - documentation: Departure point of flight segment.
     * - minOccurs: 0
     * @var mixed
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - documentation: Arrival point of flight segment.
     * - minOccurs: 0
     * @var mixed
     */
    public $ArrivalAirport;
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: Specify the airline the seat was requested for.
     * - minOccurs: 0
     * @var mixed
     */
    public $Airline;
    /**
     * The Offers
     * Meta information extracted from the WSDL
     * - documentation: Summary offer information that applies to this seat.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Offers;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: The departure date of the flight for the seat requested.
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the flight for which this seat is requested.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Code providing status information for this seat request. Refer to OpenTravel Code List Status (STS).
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for SeatRequestType
     * @uses SeatRequestType::setDepartureAirport()
     * @uses SeatRequestType::setArrivalAirport()
     * @uses SeatRequestType::setAirline()
     * @uses SeatRequestType::setOffers()
     * @uses SeatRequestType::setTPA_Extensions()
     * @uses SeatRequestType::setDepartureDate()
     * @uses SeatRequestType::setFlightNumber()
     * @uses SeatRequestType::setStatus()
     * @param mixed $departureAirport
     * @param mixed $arrivalAirport
     * @param mixed $airline
     * @param mixed[] $offers
     * @param mixed $tPA_Extensions
     * @param string $departureDate
     * @param string $flightNumber
     * @param string $status
     */
    public function __construct($departureAirport = null, $arrivalAirport = null, $airline = null, array $offers = array(), $tPA_Extensions = null, $departureDate = null, $flightNumber = null, $status = null)
    {
        $this
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setAirline($airline)
            ->setOffers($offers)
            ->setTPA_Extensions($tPA_Extensions)
            ->setDepartureDate($departureDate)
            ->setFlightNumber($flightNumber)
            ->setStatus($status);
    }
    /**
     * Get DepartureAirport value
     * @return mixed|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param mixed $departureAirport
     * @return \StructType\SeatRequestType
     */
    public function setDepartureAirport($departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return mixed|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param mixed $arrivalAirport
     * @return \StructType\SeatRequestType
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get Airline value
     * @return mixed|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param mixed $airline
     * @return \StructType\SeatRequestType
     */
    public function setAirline($airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get Offers value
     * @return mixed[]|null
     */
    public function getOffers()
    {
        return $this->Offers;
    }
    /**
     * This method is responsible for validating the values passed to the setOffers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOffersForArrayConstraintsFromSetOffers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatRequestTypeOffersItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatRequestTypeOffersItem) ? get_class($seatRequestTypeOffersItem) : sprintf('%s(%s)', gettype($seatRequestTypeOffersItem), var_export($seatRequestTypeOffersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offers property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offers value
     * @throws \InvalidArgumentException
     * @param mixed[] $offers
     * @return \StructType\SeatRequestType
     */
    public function setOffers(array $offers = array())
    {
        // validation for constraint: array
        if ('' !== ($offersArrayErrorMessage = self::validateOffersForArrayConstraintsFromSetOffers($offers))) {
            throw new \InvalidArgumentException($offersArrayErrorMessage, __LINE__);
        }
        $this->Offers = $offers;
        return $this;
    }
    /**
     * Add item to Offers value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatRequestType
     */
    public function addToOffers($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Offers property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offers[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\SeatRequestType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\SeatRequestType
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @uses \EnumType\FlightNumberType::valueIsValid()
     * @uses \EnumType\FlightNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightNumber
     * @return \StructType\SeatRequestType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlightNumberType::valueIsValid($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FlightNumberType', is_array($flightNumber) ? implode(', ', $flightNumber) : var_export($flightNumber, true), implode(', ', \EnumType\FlightNumberType::getValidValues())), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\SeatRequestType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
