<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: AWG to revisit. | Seating requests for each passenger for each air leg of this trip.
 * @subpackage Structs
 */
class SeatRequest extends SeatRequestType
{
    /**
     * The TravelerRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: One or more travelers to whom this request applies.
     * - use: optional
     * @var list
     */
    public $TravelerRefNumberRPHList;
    /**
     * The FlightRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: One or more flights to whom this request applies.
     * - use: optional
     * @var list
     */
    public $FlightRefNumberRPHList;
    /**
     * The PartialSeatingInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the carrier supports partial seating. When false, the carrier does not support partial seating.
     * - use: optional
     * @var bool
     */
    public $PartialSeatingInd;
    /**
     * Constructor method for SeatRequest
     * @uses SeatRequest::setTravelerRefNumberRPHList()
     * @uses SeatRequest::setFlightRefNumberRPHList()
     * @uses SeatRequest::setPartialSeatingInd()
     * @param list $travelerRefNumberRPHList
     * @param list $flightRefNumberRPHList
     * @param bool $partialSeatingInd
     */
    public function __construct(list $travelerRefNumberRPHList = null, list $flightRefNumberRPHList = null, $partialSeatingInd = null)
    {
        $this
            ->setTravelerRefNumberRPHList($travelerRefNumberRPHList)
            ->setFlightRefNumberRPHList($flightRefNumberRPHList)
            ->setPartialSeatingInd($partialSeatingInd);
    }
    /**
     * Get TravelerRefNumberRPHList value
     * @return list|null
     */
    public function getTravelerRefNumberRPHList()
    {
        return $this->TravelerRefNumberRPHList;
    }
    /**
     * Set TravelerRefNumberRPHList value
     * @param list $travelerRefNumberRPHList
     * @return \StructType\SeatRequest
     */
    public function setTravelerRefNumberRPHList(list $travelerRefNumberRPHList = null)
    {
        $this->TravelerRefNumberRPHList = $travelerRefNumberRPHList;
        return $this;
    }
    /**
     * Get FlightRefNumberRPHList value
     * @return list|null
     */
    public function getFlightRefNumberRPHList()
    {
        return $this->FlightRefNumberRPHList;
    }
    /**
     * Set FlightRefNumberRPHList value
     * @param list $flightRefNumberRPHList
     * @return \StructType\SeatRequest
     */
    public function setFlightRefNumberRPHList(list $flightRefNumberRPHList = null)
    {
        $this->FlightRefNumberRPHList = $flightRefNumberRPHList;
        return $this;
    }
    /**
     * Get PartialSeatingInd value
     * @return bool|null
     */
    public function getPartialSeatingInd()
    {
        return $this->PartialSeatingInd;
    }
    /**
     * Set PartialSeatingInd value
     * @param bool $partialSeatingInd
     * @return \StructType\SeatRequest
     */
    public function setPartialSeatingInd($partialSeatingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($partialSeatingInd) && !is_bool($partialSeatingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($partialSeatingInd, true), gettype($partialSeatingInd)), __LINE__);
        }
        $this->PartialSeatingInd = $partialSeatingInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
